package com.xforceplus.dao.impl;

import com.xforceplus.dao.TenantCustomizedDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.entity.Tenant;
import org.springframework.util.Assert;

import java.util.List;

@SuppressWarnings("all")
public class TenantCustomizedDaoImpl extends AbstractDefaultJpaRepositoryImpl implements TenantCustomizedDao {

    @Override
    public List<Tenant> listTenantIdByAccountId(Long accountId) {
        StringQuery query = StringQuery.builder()
                .query("  select distinct tenant_id from sys_user where 1=1 ")
                .predicateNotNull(accountId).query(" and account_id =:accountId ")
                .param("accountId", accountId)
                .query(" and status = 1").build();
        return this.findBySql(query, Tenant.class, Boolean.TRUE);
    }

    @Override
    public List<Tenant> listTenantByIds(List<Long> tenantIdList) {
        StringQuery query = StringQuery.builder()
                .query("  SELECT tenant_id,\n" +
                        "    tenant_name,\n" +
                        "    tenant_code,\n" +
                        "    tenant_desc,\n" +
                        "    status,\n" +
                        "    tenant_logo\n " +
                        " FROM bss_tenant where 1=1 ")
                .predicateNotEmpty(tenantIdList).query(" and tenant_id in (:tenantIdList) ")
                .param("tenantIdList", tenantIdList)
                .query(" and status = 1").build();
        return this.findBySql(query, Tenant.class, Boolean.TRUE);
    }


    @Override
    public List<Tenant> listTenantByAccountId(Long accountId) {
        Assert.notNull(accountId, "accountId为空！");
        StringQuery query = StringQuery.builder()
                .query(" select bt.`tenant_id`,\n" +
                        "       bt.`tenant_name`,\n" +
                        "       bt.`tenant_code`,\n" +
                        "       bt.`tenant_desc`,\n" +
                        "       bt.`operate_reason`,\n" +
                        "       bt.`settled_origin`,\n" +
                        "\t   bt.`status`,\n" +
                        "\t   bt.`status_time` ,\n" +
                        "\t   bt.`tenant_logo` ,\n" +
                        "\t   bt.`create_user_id` as  creater_id,\n" +
                        "       bt.`create_user_name` as creater_name,\n" +
                        "\t   bt.`create_time`,\n" +
                        "\t   bt.`update_user_id` as updater_id,\n" +
                        "\t   bt.`update_user_name` as updater_name,\n" +
                        "       bt.`update_time` as update_time\n" +
                        "    from\n" +
                        "        bss_tenant  bt\n" +
                        "  where tenant_id in (\n" +
                        "  select distinct tenant_id from sys_user where \n" +
                        "        account_id=:accountId \n" +
                        "        and status=1 \n" +
                        "        )\n" +
                        "        and bt.status=1 \n" +
                        "   ").param("accountId", accountId)
                .build();

        return this.findBySql(query, Tenant.class, Boolean.TRUE);
    }

}
