package com.xforceplus.dao.impl;

import com.xforceplus.dao.UserCustomizedDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.domain.tenant.TenantManagerDto;

import java.util.List;

@SuppressWarnings("all")
public class UserCustomizedDaoImpl extends AbstractDefaultJpaRepositoryImpl implements UserCustomizedDao {

    @Override
    public List<TenantManagerDto> findTenantManager(List<Long> tenantIds) {
        StringQuery query = StringQuery.builder()
                .query("  select a.username as account " +
                        " ,a.email as email_account" +
                        " ,a.tel_phone as phone_account" +
                        " ,b.user_id" +
                        " ,b.user_name as name" +
                        " ,b.tenant_id" +
                        " from sys_sass_account a " +
                        " left join sys_user b on a.account_id = b.account_id  " +
                        " left join sys_role_user_rel c on b.user_id = c.user_id " +
                        " where c.role_id=1 and b.tenant_id in(:tenantIds) " +
                        " and b.`status`=1 ")
                .param("tenantIds", tenantIds).build();
        return this.findBySql(query, TenantManagerDto.class, Boolean.TRUE);
    }
}
