/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: OrgUserExtendDao.java   2020-12-28 16-29-53
 * Author: Evan
 */
package com.xforceplus.dao.user.impl;

import com.xforceplus.bo.user.OrgUserBO;
import com.xforceplus.bo.user.OrgUserComplexBO;
import com.xforceplus.dao.user.OrgUserExtendDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.dto.user.OrgUserDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-12-28 16-29-53
 * @since V1.0
 */
@Repository
public class OrgUserExtendDaoImpl extends AbstractDefaultJpaRepositoryImpl implements OrgUserExtendDao {

    /**
     * 查询当前组的SQL
     */
    protected static final String SQL_CURRENT_ORG = " SELECT DISTINCT su.user_id, sos.tenant_id, sos.org_code,sos.org_struct_id AS org_id," +
            " sos.company_id, su.`status` AS user_status, su.user_type, su.user_name real_name, su.user_code," +
            " su.user_number, su.user_phone user_tel_phone, su.create_time, su.account_id, ssa.username account_user_name," +
            " ssa.email account_email,ssa.tel_phone AS account_tel_phone, sour.create_time bound_time FROM sys_org_struct sos, sys_org_user_rel sour," +
            " sys_user su, sys_sass_account ssa WHERE sos.org_struct_id = sour.org_struct_id" +
            " AND sour.user_id = su.user_id AND su.account_id = ssa.account_id";

    /**
     * 查询当前节点
     *
     * @param pageable  分页
     * @param orgUserBO OrgUserBO
     * @return Page<OrgUserDTO>
     */
    @Override
    public Page<OrgUserDTO> pageByCurrentOrg(Pageable pageable, OrgUserBO orgUserBO) {
        StringQuery stringQuery = StringQuery.builder().query(SQL_CURRENT_ORG)
                .predicateNotNull(orgUserBO.getOrgId())
                .query(" and sos.org_struct_id = :orgId").param("orgId", orgUserBO.getOrgId())
                .predicateNotNull(orgUserBO.getUserStatus())
                .query(" and su.status = :status").param("status", orgUserBO.getUserStatus())
                .build();
        // 使用下划线转换器
        return super.pagingSqlBy(
                pageable, stringQuery.getQuery(), stringQuery.getParams(), OrgUserDTO.class, Boolean.TRUE);
    }


    /**
     * 查询当前节点的用户及以下用户的数据
     *
     * @param pageable  分页
     * @param orgUserBO 查询条件
     * @return Page<OrgUserDTO>
     */
    @Override
    public Page<OrgUserDTO> pageByBelongOrg(Pageable pageable, OrgUserBO orgUserBO) {
        StringQuery stringQuery = StringQuery.builder().query(SQL_CURRENT_ORG)
                .predicateNotNull(orgUserBO.getParentIds())
                .query(" and sos.parent_ids like :parentIds").likeStartParam("parentIds", orgUserBO.getParentIds())
                .predicateNotNull(orgUserBO.getUserStatus())
                .query(" and su.status=:status").param("status", orgUserBO.getUserStatus())
                .build();
        // 使用下划线转换器
        return super.pagingSqlBy(
                pageable, stringQuery.getQuery(), stringQuery.getParams(), OrgUserDTO.class, Boolean.TRUE);
    }

    /**
     * 查询当前节点的用户
     *
     * @param pageable  {@link Pageable}
     * @param orgUserBO OrgUserComplexBO
     * @return Page<OrgUserDTO>
     */
    @Override
    public Page<OrgUserDTO> pageByCurrentOrgQueryType(Pageable pageable, OrgUserComplexBO orgUserBO) {
        StringQuery stringQuery = StringQuery.builder().query(SQL_CURRENT_ORG)
                .predicateNotNull(orgUserBO.getOrgId())
                .query(" AND sos.org_struct_id = :orgId").param("orgId", orgUserBO.getOrgId())
                .predicateNotNull(orgUserBO.getOrgCode())
                .query(" AND sos.org_code = :orgCode").param("orgCode", orgUserBO.getOrgCode())
                .predicateNotNull(orgUserBO.getOrgName())
                .query(" AND sos.org_name like :orgName").likeStartParam("orgName", orgUserBO.getOrgName())
                .predicateNotNull(orgUserBO.getUserStatus())
                .query(" AND su.status = :status").param("status", orgUserBO.getUserStatus())
                .predicateNotNull(orgUserBO.getCreatedDateBegin())
                .query(" AND su.create_time >= :beginDate")
                .param("beginDate", orgUserBO.getCreatedDateBegin())
                .predicateNotNull(orgUserBO.getCreatedDateEnd())
                .query(" AND su.create_time < :endDate")
                .param("endDate", orgUserBO.getCreatedDateEnd())
                .predicateNotNull(orgUserBO.getBoundDateBegin())
                .query(" AND sour.create_time >= :boundBeginDate")
                .param("boundBeginDate", orgUserBO.getBoundDateBegin())
                .predicateNotNull(orgUserBO.getBoundDateEnd())
                .query(" AND sour.create_time < :boundEndDate")
                .param("boundEndDate", orgUserBO.getBoundDateEnd())
                .build();
        // 使用下划线转换器
        return super.pagingSqlBy(pageable, stringQuery, OrgUserDTO.class, Boolean.TRUE);
    }

    /**
     * 复杂条件查询当前节点的用户及以下用户
     *
     * @param pageable  {@link Pageable}
     * @param orgUserBO 查询条件
     * @return Page<OrgUserDTO>
     */
    @Override
    public Page<OrgUserDTO> pageByBelongOrgQueryType(Pageable pageable, OrgUserComplexBO orgUserBO) {
        StringQuery stringQuery = StringQuery.builder().query(SQL_CURRENT_ORG)
                .predicateNotNull(orgUserBO.getParentIds())
                .query(" AND sos.parent_ids like :parentIds ").likeStartParam("parentIds", orgUserBO.getParentIds())
                .predicateNotNull(orgUserBO.getUserStatus())
                .query(" AND su.status = :status").param("status", orgUserBO.getUserStatus())
                .predicateNotNull(orgUserBO.getCreatedDateBegin())
                .query(" AND su.create_time >= :beginDate")
                .param("beginDate", orgUserBO.getCreatedDateBegin())
                .predicateNotNull(orgUserBO.getCreatedDateEnd())
                .query(" AND su.create_time < :endDate")
                .param("endDate", orgUserBO.getCreatedDateEnd())
                .predicateNotNull(orgUserBO.getBoundDateBegin())
                .query(" AND sour.create_time >= :boundBeginDate")
                .param("boundBeginDate", orgUserBO.getBoundDateBegin())
                .predicateNotNull(orgUserBO.getBoundDateEnd())
                .query(" AND sour.create_time < :boundEndDate")
                .param("boundEndDate", orgUserBO.getBoundDateEnd())
                .build();
        // 使用下划线转换器
        return super.pagingSqlBy(pageable, stringQuery, OrgUserDTO.class, Boolean.TRUE);
    }


}
