package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.account.AccountPlatformRelDto;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author Evan
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_account_platform_rel")
public class AccountPlatformRel extends AccountPlatformRelDto implements Serializable {

    @Override
    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Override
    @Basic
    @Column(name = "account_id", nullable = false)
    public Long getAccountId() {
        return accountId;
    }

    @Override
    @Basic
    @Column(name = "platform_type", nullable = false)
    public Integer getPlatformType() {
        return platformType;
    }

    @Override
    @Basic
    @Column(name = "platform_id", nullable = false)
    public String getPlatformId() {
        return platformId;
    }

    @Override
    @Basic
    @Column(name = "platform_app_id")
    public String getPlatformAppId() {
        return platformAppId;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "enable_time")
    public Date getEnableTime() {
        return super.getEnableTime();
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return super.getCreateTime();
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return super.getUpdateTime();
    }

    @Override
    @Basic
    @Column(name = "user_id")
    public String getUserId() {
        return userId;
    }

    @Override
    @Basic
    @Column(name = "app_type")
    public String getAppType() {
        return appType;
    }

    @Override
    @Basic
    @Column(name = "ext1")
    public String getExt1() {
        return ext1;
    }

    @Override
    @Basic
    @Column(name = "ext2")
    public String getExt2() {
        return ext2;
    }

    @Override
    @Basic
    @Column(name = "ext3")
    public String getExt3() {
        return ext3;
    }

}
