package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.account.AccountPrivacyDto;
import com.xforceplus.jpa.listener.AccountListener;
import com.xforceplus.jpa.listener.AccountPrivacyListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

/**
 * @Author: HWT
 * @Date: 2021/8/27 14:08
 */

@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({AccountPrivacyListener.class})
@Setter
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_account_privacy")
public class AccountPrivacy extends AccountPrivacyDto implements Serializable {



  @Override
  @Id
  @Column(name = "id", nullable = false)
  @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
  @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
  public Long getId() {
    return id;
  }

  @Override
  @Basic
  @Column(name = "account_id", nullable = false)
  public Long getAccountId() {
    return accountId;
  }


  @Override
  @Basic
  @Column(name = "web_site", nullable = false)
  public String getWebSite() {
    return webSite;
  }

  @Override
  @Basic
  @Column(name = "version")
  public String getVersion() {
    return version;
  }


  @Override
  @Basic
  @Column(name = "create_user_id", updatable = false)
  public String getCreaterId() {
    return createrId;
  }

  @Override
  @Basic
  @Column(name = "create_user_name", updatable = false)
  public String getCreaterName() {
    return createrName;
  }

  @Override
  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "create_time", updatable = false)
  public Date getCreateTime() {
    return createTime;
  }

  @Override
  @Basic
  @Column(name = "update_user_id")
  public String getUpdaterId() {
    return updaterId;
  }

  @Override
  @Basic
  @Column(name = "update_user_name")
  public String getUpdaterName() {
    return updaterName;
  }

  @Override
  @Temporal(TemporalType.TIMESTAMP)
  @Column(name = "update_time")
  public Date getUpdateTime() {
    return updateTime;
  }


}
