package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.company.CompanyExtensionDto;
import com.xforceplus.jpa.listener.CompanyExtensionListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({CompanyExtensionListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "company_extension")
public class CompanyExtension extends CompanyExtensionDto implements Serializable {

    private Long companyExtensionId;

    @Id
    @Column(name = "company_extension_id")
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getCompanyExtensionId() {
        return companyExtensionId;
    }

    @Override
    @Column(name = "company_id", nullable = false)
    public Long getCompanyId() {
        return super.companyId;
    }

    @Override
    @Basic
    @Column(name = "extension_key", nullable = false)
    public String getExtensionKey() {
        return super.extensionKey;
    }

    @Override
    @Basic
    @Column(name = "extension_value", nullable = false)
    public String getExtensionValue() {
        return super.extensionValue;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return super.status;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return super.createTime;
    }


    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return super.updateTime;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
