package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_org_companyno")
public class OrgCompanyRel implements Serializable {
    private Long id;
    private Long orgStructId;
    private String companyNo;

    @JsonIgnore
    private OrgStruct org;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "org_struct_id", nullable = false)
    public Long getOrgStructId() {
        return orgStructId;
    }

    @Basic
    @Column(name = "company_no", nullable = false)
    public String getCompanyNo() {
        return companyNo;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "org_struct_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public OrgStruct getOrg() {
        return org;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        OrgCompanyRel that = (OrgCompanyRel) o;

        if (!getOrgStructId().equals(that.getOrgStructId())) {
            return false;
        }
        return getCompanyNo().equals(that.getCompanyNo());
    }

    @Override
    public int hashCode() {
        int result = getOrgStructId().hashCode();
        result = 31 * result + getCompanyNo().hashCode();
        return result;
    }
}
