package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author geewit
 */
@SuppressWarnings("all")
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_resourceset_resource_rel")
public class ResourcesetResourceRel implements Serializable {
    private Long id;
    private Long resourceId;
    private Long resourcesetId;
    private String createUserName;
    @JsonIgnore
    private Resource resource;
    @JsonIgnore
    private Resourceset resourceset;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "resource_id", nullable = false)
    public Long getResourceId() {
        return (resourceId != null && resourceId > 0) ? resourceId : null;
    }

    @Basic
    @Column(name = "resourceset_id", nullable = false)
    public Long getResourcesetId() {
        return (resourcesetId != null && resourcesetId > 0) ? resourcesetId : null;
    }

    @Basic
    @Column(name = "create_user_name")
    public String getCreateUserName() {
        return createUserName;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "resource_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
//    @NotFound(action = NotFoundAction.IGNORE)
    public Resource getResource() {
        return resource;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "resourceset_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
//    @NotFound(action = NotFoundAction.IGNORE)
    public Resourceset getResourceset() {
        return resourceset;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourcesetResourceRel that = (ResourcesetResourceRel) o;
        return resourceId.equals(that.resourceId) &&
                resourcesetId.equals(that.resourcesetId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, resourcesetId);
    }

    @Override
    public String toString() {
        return "ResourcesetResourceRel{" +
                "id=" + id +
                ", resourceId=" + resourceId +
                ", resourcesetId=" + resourcesetId +
                '}';
    }
}
