package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_role_user_rel")
public class RoleUserRel implements Serializable {
    private Long id;
    private Long roleId;
    private Long userId;
    private Long userGroupId;
    private Long tenantId;
    private int relType;

    @JsonIgnore
    private Role role;

    @JsonIgnore
    private User user;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "role_id", nullable = false)
    public Long getRoleId() {
        return (roleId != null && roleId > 0) ? roleId : null;
    }

    @Basic
    @Column(name = "user_id", nullable = false)
    public Long getUserId() {
        return (userId != null && userId > 0) ? userId : null;
    }

    @Basic
    @Column(name = "user_group_id")
    public Long getUserGroupId() {
        return userGroupId;
    }

    @Basic
    @Column(name = "rel_type", nullable = false)
    public int getRelType() {
        return relType;
    }

    @Basic
    @Column(name = "tenant_id", nullable = false)
    public Long getTenantId() {
        return (tenantId != null && tenantId > 0) ? tenantId : null;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "role_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Role getRole() {
        return role;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "user_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public User getUser() {
        return user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RoleUserRel that = (RoleUserRel) o;
        return roleId.equals(that.roleId) &&
                userId.equals(that.userId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(roleId, userId);
    }

    @Override
    public String toString() {
        return "RoleUserRel{" +
            "id=" + id +
            ", roleId=" + roleId +
            ", userId=" + userId +
            ", userGroupId=" + userGroupId +
            ", tenantId=" + tenantId +
            ", relType=" + relType +
            ", role=" + role +
            ", user=" + user +
            '}';
    }
}
