package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "settle_flow_template_rel")
public class SettleFlowTemplateRel implements Serializable {
    private Long id;

    private Long flowId;

    private Long templateId;

    private Integer pageIndex;

    private SettleFlow flow;

    private SettleTemplate template;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "flow_id")
    public Long getFlowId() {
        return (flowId != null && flowId > 0) ? flowId : null;
    }

    @Basic
    @Column(name = "template_id")
    public Long getTemplateId() {
        return (templateId != null && templateId > 0) ? templateId : null;
    }

    @Basic
    @Column(name = "page_index")
    public Integer getPageIndex() {
        return pageIndex;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "flow_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public SettleFlow getFlow() {
        return flow;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "template_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public SettleTemplate getTemplate() {
        return template;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SettleFlowTemplateRel that = (SettleFlowTemplateRel) o;
        return Objects.equals(flowId, that.flowId) &&
                (Objects.equals(templateId, that.templateId) || Objects.equals(pageIndex, that.pageIndex));
    }

    @Override
    public int hashCode() {
        return Objects.hash(flowId);
    }
}
