package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.geewit.web.utils.JsonUtils;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.persistence.*;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@NamedEntityGraphs({
        @NamedEntityGraph(name = SettleTemplate.NAMED_ENTITY_GRAPH_DEFAULT,
                attributeNodes = {//attributeNodes 来定义需要懒加载的属性
                        @NamedAttributeNode("attributes")
                }
        )})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "settle_template")
public class SettleTemplate implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(SettleTemplate.class);

    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "SettleTemplate.graph";

    private Long templateId;
    private String templateName;
    private String rawProperties;
    private String templateCode;
    private Integer pageIndex;
    private List<SettleTemplateAttribute> attributes;
    private List<String> serviceCodes;


    @Basic
    @Column(name = "template_code")
    public String getTemplateCode() {
        return templateCode;
    }

    @Id
    @Column(name = "template_id")
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getTemplateId() {
        return templateId;
    }

    @Basic
    @Column(name = "template_name")
    public String getTemplateName() {
        return templateName;
    }

    @Basic
    @Column(name = "properties")
    public String getRawProperties() {
        return rawProperties;
    }

    @OneToMany(fetch = FetchType.LAZY)
    @JoinColumn(name = "template_id", insertable = false, updatable = false, referencedColumnName = "template_id", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public List<SettleTemplateAttribute> getAttributes() {
        return attributes;
    }

    @Transient
    public List<String> getServiceCodes() {
        return serviceCodes;
    }

    @Transient
    public Integer getPageIndex() {
        return pageIndex;
    }

    @Transient
    public Map<String, String> geProperties(Map<String, String> flowProperties) {
        if (this.rawProperties != null) {
            try {
                Map<String, String> properties = JsonUtils.fromJson(this.rawProperties, new TypeReference<Map<String, String>>() {
                });
                if (flowProperties == null) {
                    flowProperties = new HashMap<>(properties);
                } else {
                    flowProperties.putAll(properties);
                }
                return flowProperties;
            } catch (Exception e) {
                logger.warn(e.getMessage(), e);
                return new HashMap<>(0);
            }
        }
        if (flowProperties == null) {
            return new HashMap<>(0);
        } else {
            return flowProperties;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SettleTemplate that = (SettleTemplate) o;
        return Objects.equals(templateId, that.templateId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(templateId);
    }

    @Override
    public String toString() {
        return "SettleTemplate{" +
                "templateId=" + templateId +
                ", templateName='" + templateName + '\'' +
                ", rawProperties='" + rawProperties + '\'' +
                '}';
    }
}
