package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.tenant.TenantPolicyDto;
import com.xforceplus.jpa.listener.TenantPolicyListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.*;

import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({TenantPolicyListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "tenant_policy")
public class TenantPolicy extends TenantPolicyDto<Tenant> implements Serializable {
    @Override
    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Override
    @Basic
    @Column(name = "tenant_id", nullable = false)
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    @Basic
    @Column(name = "name", nullable = false)
    public String getName() {
        return name;
    }

    @Override
    @Basic
    @Column(name = "policy", nullable = false)
    public String getPolicy() {
        return policy;
    }

    @Override
    @Basic
    @Column(name = "updater_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "updater_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }


    @Override
    @ManyToOne(fetch = FetchType.LAZY)
    @NotFound(action = NotFoundAction.IGNORE)
    @JoinColumn(name = "tenant_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return tenant;
    }

    @Override
    public boolean equals(Object o) {
        if (null == o){
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        TenantPolicy that = (TenantPolicy) o;
        return getTenantId().equals(that.getTenantId()) &&
                getName().equals(that.getName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getTenantId(), getName());
    }
}
