package com.xforceplus.jpa.listener;


import com.xforceplus.entity.Company;
import io.geewit.utils.uuid.UUID;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 公司自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class CompanyListener extends OperatorListener<Company> {
    @PrePersist
    public void prePersist(Company entity) {
        if (StringUtils.isEmpty(entity.getCompanyCode())) {
            String companyCode = UUID.randomUUID().toString();
            entity.setCompanyCode(companyCode);
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (StringUtils.isBlank(entity.getTaxNum())) {
            throw new IllegalArgumentException("公司税号不能为空");
        }
        if (StringUtils.isBlank(entity.getCompanyName())) {
            throw new IllegalArgumentException("公司名称不能为空");
        }

        if (entity.getEffective() == null) {
            entity.setEffective(true);
        }
        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(Company entity) {
        if (entity.getEffective() == null) {
            entity.setEffective(true);
        }
        super.beforeUpdate(entity);
    }
}