package com.xforceplus.query;

import com.xforceplus.api.model.AppModel;
import com.xforceplus.entity.App;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("all")
public class AppQueryHelper {
    public static Specification<App> querySpecification(AppModel.Request.Query query) {
        Specification<App> specification = (Specification<App>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getAppId() != null && query.getAppId() > 0) {
                predicates.add(builder.equal(root.<Long>get("appId"), query.getAppId()));
            }
            if (StringUtils.isNotBlank(query.getAppName())) {
                predicates.add(builder.like(root.<String>get("appName"), query.getAppName() + "%"));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

}
