package com.xforceplus.query;

import com.xforceplus.api.model.CompanyTenantRelOperationModel.Request.Query;
import com.xforceplus.domain.company.Switch;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyTenantRelOperation;
import com.xforceplus.entity.Tenant;
import io.geewit.data.jpa.essential.function.Functions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.Tuple;
import javax.persistence.criteria.*;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author geewit
 */
@SuppressWarnings("all")
public class CompanyTenantRelOperationQueryHelper {
    /***
     * ID {@value}
     */
    public static final String ID = "id";
    /***
     * 税号字段名 {@value}
     */
    public static final String TAX_NUM = "taxNum";
    /***
     * 公司名称字段 {@value}
     */
    public static final String COMPANY_NAME = "companyName";
    /***
     * 公司代码：{@value}
     */
    public static final String COMPANY_CODE = "companyCode";
    /***
     * 租户ID {@value}
     */
    public static final String TENANT_ID = "tenantId";
    /***
     * 租户代码 {@value}
     */
    public static final String TENANT_CODE = "tenantCode";
    /***
     * 租户名称 {@value}
     */
    public static final String TENANT_NAME = "tenantName";
    /***
     * 公司ID :{@value}
     */
    public static final String COMPANY_ID = "companyId";
    /***
     * 操作类型 {@value}
     */
    public static final String OPERATION_TYPE = "operationType";
    /***
     * 审核状态 {@value}
     */
    public static final String STATUS = "status";
    /***
     * 开关 {@value}
     */
    public static final String SWITCHES = "switches";
    /**
     * 被关联租户id
     */
    public static final String RELATED_TENANT_ID = "relatedTenantId";
    /**
     * 被关联租户name
     */
    public static final String RELATED_TENANT_NAME = "relatedTenantName";
    /***
     * 租户ID {@value}
     */
    public static final String CREATER_TENANT_ID = "createrTenantId";

    /**
     * 所属租户主体公司id
     */
    public static final String INVITING_COMPANY_ID = "invitingCompanyId";

    /**
     * 所属租户主体公司名称
     */
    public static final String INVITING_COMPANY_NAME = "invitingCompanyName";

    public static Specification<CompanyTenantRelOperation> querySpecification(Query query) {
        Specification<CompanyTenantRelOperation> specification = (Specification<CompanyTenantRelOperation>) (root, criteriaQuery, builder) -> {
            return toPredicate(query, root, criteriaQuery, builder);
        };
        return specification;
    }

    public static Predicate queryTuplePredicate(Query query, Root<CompanyTenantRelOperation> root, CriteriaQuery<Tuple> criteriaQuery, CriteriaBuilder builder) {
        return toPredicate(query, root, criteriaQuery, builder);
    }

    public static Predicate queryCountPredicate(Query query, Root<CompanyTenantRelOperation> root, CriteriaQuery<Long> criteriaQuery, CriteriaBuilder builder) {
        return toPredicate(query, root, criteriaQuery, builder);
    }

    private static <T> Predicate toPredicate(Query query, Root<CompanyTenantRelOperation> root, CriteriaQuery<T> criteriaQuery, CriteriaBuilder builder) {
        List<Predicate> predicates = new ArrayList<>();
        Class<T> resultType = criteriaQuery.getResultType();
        if(query.isTuple() && resultType.isAssignableFrom(Tuple.class)) {
            Join<CompanyTenantRelOperation, Company> joinCompany = root.join("company", JoinType.LEFT);
            Join<Company, Tenant> joinTenant = joinCompany.join("hostTenant", JoinType.LEFT);
            List<Selection<?>> selections = Stream.of(root.alias("operation")).collect(Collectors.toList());
            if(query.isHasHostTenantId()) {
                selections.add(joinTenant.<Long>get(TENANT_ID).alias("hostTenantId"));
            }
            if(query.isHasHostTenantCode()) {
                selections.add(joinTenant.<String>get("tenantCode").alias("hostTenantCode"));
            }
            if(query.isHasHostTenantName()) {
                selections.add(joinTenant.<String>get("tenantName").alias("hostTenantName"));
            }
            criteriaQuery = criteriaQuery.multiselect(selections);
        }
        if (query.getId() != null && query.getId() > 0) {
            predicates.add(builder.equal(root.<Long>get(ID), query.getId()));
        }
        if (query.getTenantId() != null && query.getTenantId() > 0) {
            predicates.add(builder.equal(root.<Long>get(TENANT_ID), query.getTenantId()));
        }
        if (StringUtils.isNotBlank(query.getTenantName())) {
            predicates.add(builder.like(root.<String>get(TENANT_NAME), query.getTenantName() + "%"));
        }
        if (StringUtils.isNotBlank(query.getTenantCode())) {
            predicates.add(builder.like(root.<String>get(TENANT_CODE), query.getTenantCode() + "%"));
        }
        if (query.getInvitingCompanyId() != null && query.getInvitingCompanyId() > 0) {
            predicates.add(builder.equal(root.<Long>get(INVITING_COMPANY_ID), query.getInvitingCompanyId()));
        }
        if (StringUtils.isNotBlank(query.getInvitingCompanyName())) {
            predicates.add(builder.like(root.<String>get(INVITING_COMPANY_NAME), query.getInvitingCompanyName() + "%"));
        }
        if (StringUtils.isNotBlank(query.getCompanyCode())) {
            predicates.add(builder.like(root.<String>get(COMPANY_CODE), query.getCompanyCode() + "%"));
        }
        if (StringUtils.isNotBlank(query.getTaxNum())) {
            predicates.add(builder.like(root.<String>get(TAX_NUM), query.getTaxNum() + "%"));
        }
        if (StringUtils.isNotBlank(query.getCompanyName())) {
            predicates.add(builder.like(root.get(COMPANY_NAME), query.getCompanyName() + "%"));
        }
        if (query.getCompanyId() != null && query.getCompanyId() > 0) {
            predicates.add(builder.equal(root.<Long>get(COMPANY_ID), query.getCompanyId()));
        }
        if (query.getCreaterTenantId() != null && query.getCreaterTenantId() > 0) {
            predicates.add(builder.equal(root.<Long>get(CREATER_TENANT_ID), query.getCreaterTenantId()));
        }
        if (query.getRelatedTenantId() != null && query.getRelatedTenantId() > 0) {
            predicates.add(builder.equal(root.<Long>get(RELATED_TENANT_ID), query.getRelatedTenantId()));
        }
        if (StringUtils.isNotBlank(query.getRelatedTenantName())) {
            predicates.add(builder.like(root.get(RELATED_TENANT_NAME), query.getRelatedTenantName() + "%"));
        }
        if (StringUtils.isNotBlank(query.getAllSwitches())) {
            String[] switches = StringUtils.split(query.getAllSwitches(), ",");
            int allSwitches = Switch.toValue(query.getAllSwitches());
            predicates.add(builder.equal(builder.function(Functions.BITWISE_AND, Integer.class, root.<Integer>get(SWITCHES), builder.literal(allSwitches)), allSwitches));
        }
        if (StringUtils.isNotBlank(query.getAnySwitches())) {
            String[] switches = StringUtils.split(query.getAnySwitches(), ",");
            int anySwitches = Switch.toValue(query.getAnySwitches());
            predicates.add(builder.gt(builder.function(Functions.BITWISE_AND, Integer.class, root.<Integer>get(SWITCHES), builder.literal(anySwitches)), 0));
        }
        if (query.getOperationType() != null) {
            predicates.add(builder.equal(root.<Integer>get(OPERATION_TYPE), query.getOperationType()));
        }
        if ((query.getOperationType() == null || query.getOperationType() == 0) && query.getStatus() != null) {
            predicates.add(builder.equal(root.<Integer>get(STATUS), query.getStatus()));
        }
        if (query.getWithoutStatus() != null && query.getWithoutStatus() > 0) {
            predicates.add(builder.notEqual(root.<Integer>get(STATUS), query.getWithoutStatus()));
        }
        if (!predicates.isEmpty()) {
            criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
        }
        return criteriaQuery.getRestriction();
    }

    public static Specification<CompanyTenantRelOperation> queryOneSpecification(Query query) {
        Specification<CompanyTenantRelOperation> specification = (Specification<CompanyTenantRelOperation>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get(TENANT_ID), query.getTenantId()));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                predicates.add(builder.equal(root.<Long>get(COMPANY_ID), query.getCompanyId()));
            }
            if (query.getCreaterTenantId() != null && query.getCreaterTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get(CREATER_TENANT_ID), query.getCreaterTenantId()));
            }
            if (StringUtils.isNotBlank(query.getCompanyCode()) || StringUtils.isNotBlank(query.getTaxNum()) || StringUtils.isNotBlank(query.getCompanyName())) {
                Predicate predicate = builder.disjunction();
                if (StringUtils.isNotBlank(query.getCompanyCode())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(COMPANY_CODE), query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank(query.getTaxNum())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(TAX_NUM), query.getTaxNum()));
                }
                if (StringUtils.isNotBlank(query.getCompanyName())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(COMPANY_NAME), query.getCompanyName()));
                }
                if (predicate != null) {
                    predicates.add(predicate);
                }
            }
            if (StringUtils.isNotBlank(query.getAllSwitches())) {
                String[] switches = StringUtils.split(query.getAllSwitches(), ",");
                int allSwitches = Switch.toValue(query.getAllSwitches());
                predicates.add(builder.equal(builder.function(Functions.BITWISE_AND, Integer.class, root.<Integer>get(SWITCHES), builder.literal(allSwitches)), allSwitches));
            }
            if (StringUtils.isNotBlank(query.getAnySwitches())) {
                String[] switches = StringUtils.split(query.getAnySwitches(), ",");
                int anySwitches = Switch.toValue(query.getAnySwitches());
                predicates.add(builder.gt(builder.function(Functions.BITWISE_AND, Integer.class, root.<Integer>get(SWITCHES), builder.literal(anySwitches)), 0));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get(STATUS), query.getStatus()));
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("查询参数不合法");
            } else {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
