package com.xforceplus.query;

import com.xforceplus.api.model.CompanyTenantRelModel.Request.Query;
import com.xforceplus.domain.company.Switch;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.CompanyTenantRel;
import io.geewit.data.jpa.essential.function.Functions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

/**
 * @author geewit
 */
@SuppressWarnings("all")
public class CompanyTenantRelQueryHelper {
    /***
     * 公司ID :{@value}
     */
    public static final String COMPANY_ID = "companyId";
    /***
     * 税号字段名 {@value}
     */
    public static final String TAX_NUM = "taxNum";
    /***
     * 公司名称字段 {@value}
     */
    public static final String COMPANY_NAME = "companyName";
    /***
     * 公司代码：{@value}
     */
    public static final String COMPANY_CODE = "companyCode";
    /***
     * 关联租户ID {@value}
     */
    public static final String TENANT_ID = "tenantId";
    /***
     * 所属租户Code {@value}
     */
    public static final String TENANT_CODE = "tenantCode";
    /***
     * 所属租户名称 {@value}
     */
    public static final String TENANT_NAME = "tenantName";
    /***
     * 所属租户ID {@value}
     */
    public static final String HOST_TENANT_ID = "hostTenantId";
    /***
     * 关联租户ID {@value}
     */
    public static final String RELATED_TENANT_ID = "relatedTenantId";
    /***
     * 关联租户名称 {@value}
     */
    public static final String RELATED_TENANT_NAME = "relatedTenantName";
    /***
     * 关联租户编码 {@value}
     */
    public static final String RELATED_TENANT_CODE = "relatedTenantCode";
    /***
     * 公司实体 {@value}
     */
    public static final String COMPANY = "company";
    /***
     * 所属租户实体 {@value}
     */
    public static final String HOST_TENANT = "hostTenant";
    /***
     * 租户实体 {@value}
     */
    public static final String TENANT = "tenant";
    /***
     * 被关联租户实体 {@value}
     */
    public static final String RELATED_TENANT = "relatedTenant";
    /***
     * 被关联公司实体 {@value}
     */
    public static final String RELATED_COMPANY = "relatedCompany";
    /***
     * 审核状态 {@value}
     */
    public static final String STATUS = "status";
    /***
     * 开关 {@value}
     */
    public static final String SWITCHES = "switches";

    public static Specification<CompanyTenantRel> querySpecification(Query query) {
        Specification<CompanyTenantRel> specification = (Specification<CompanyTenantRel>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get(TENANT_ID), query.getTenantId()));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                predicates.add(builder.equal(root.<Long>get(COMPANY_ID), query.getCompanyId()));
            }
            if (query.getRelatedTenantId() != null && query.getRelatedTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get(RELATED_TENANT_ID), query.getRelatedTenantId()));
            }
            if (StringUtils.isNotBlank(query.getCompanyCode())
                    || StringUtils.isNotBlank(query.getTaxNum())
                    || StringUtils.isNotBlank(query.getCompanyName())
                    || (query.getTenantId() != null && query.getTenantId() > 0)
                    || StringUtils.isNotBlank(query.getHostTenantCode())
                    || StringUtils.isNotBlank(query.getHostTenantName())
            ) {
                Join<CompanyTenantRel, Company> joinCompany = root.join(COMPANY, JoinType.LEFT);
                if (StringUtils.isNotBlank(query.getCompanyCode())) {
                    predicates.add(builder.equal(joinCompany.<String>get(COMPANY_CODE), query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank(query.getTaxNum())) {
                    predicates.add(builder.equal(joinCompany.<String>get(TAX_NUM), query.getTaxNum()));
                }
                if (StringUtils.isNotBlank(query.getCompanyName())) {
                    predicates.add(builder.like(joinCompany.get(COMPANY_NAME), query.getCompanyName()));
                }
                if (query.getHostTenantId() != null && query.getHostTenantId() > 0) {
                    predicates.add(builder.equal(joinCompany.<Long>get(HOST_TENANT_ID), query.getHostTenantId()));
                }
                if(StringUtils.isNotBlank(query.getHostTenantCode()) || StringUtils.isNotBlank(query.getHostTenantName())) {
                    Join<Company, Tenant> joinTenant = joinCompany.join(HOST_TENANT, JoinType.LEFT);
                    if (StringUtils.isNotBlank(query.getHostTenantCode())) {
                        predicates.add(builder.equal(joinTenant.<String>get(TENANT_CODE), query.getHostTenantCode()));
                    }
                    if (StringUtils.isNotBlank(query.getHostTenantName())) {
                        predicates.add(builder.like(joinTenant.get(TENANT_NAME), query.getHostTenantName()));
                    }
                }
            }
            if (StringUtils.isNotBlank(query.getTenantCode()) || StringUtils.isNotBlank(query.getTenantName())) {
                Join<CompanyTenantRel, Tenant> joinTenant = root.join(TENANT, JoinType.LEFT);
                if (StringUtils.isNotBlank(query.getTenantCode())) {
                    predicates.add(builder.equal(joinTenant.<String>get(TENANT_CODE), query.getTenantCode()));
                }
                if (StringUtils.isNotBlank(query.getTenantName())) {
                    predicates.add(builder.equal(joinTenant.<String>get(TENANT_NAME), query.getTenantName()));
                }
            }
            if (StringUtils.isNotBlank(query.getRelatedTenantCode()) || StringUtils.isNotBlank(query.getRelatedTenantName())) {
                Join<CompanyTenantRel, Tenant> joinTenant = root.join(RELATED_TENANT, JoinType.LEFT);
                if (StringUtils.isNotBlank(query.getRelatedTenantCode())) {
                    predicates.add(builder.equal(joinTenant.<String>get(TENANT_CODE), query.getRelatedTenantCode()));
                }
                if (StringUtils.isNotBlank(query.getRelatedTenantName())) {
                    predicates.add(builder.equal(joinTenant.<String>get(TENANT_NAME), query.getRelatedTenantName()));
                }
            }
            if (StringUtils.isNotBlank(query.getRelatedCompanyCode()) || StringUtils.isNotBlank(query.getRelatedCompanyName())) {
                Join<CompanyTenantRel, Company> joinCompany = root.join(RELATED_COMPANY, JoinType.LEFT);
                if (StringUtils.isNotBlank(query.getRelatedCompanyCode())) {
                    predicates.add(builder.equal(joinCompany.<String>get(COMPANY_CODE), query.getRelatedCompanyCode()));
                }
                if (StringUtils.isNotBlank(query.getRelatedCompanyName())) {
                    predicates.add(builder.equal(joinCompany.<String>get(COMPANY_NAME), query.getRelatedCompanyName()));
                }
            }
            if (StringUtils.isNotBlank(query.getAllSwitches())) {
                String[] switches = StringUtils.split(query.getAllSwitches(), ",");
                int allSwitches = Switch.toValue(query.getAllSwitches());
                predicates.add(builder.equal(builder.function(Functions.BITWISE_AND, Integer.class, root.<Integer>get(SWITCHES), builder.literal(allSwitches)), allSwitches));
            }
            if (StringUtils.isNotBlank(query.getAnySwitches())) {
                String[] switches = StringUtils.split(query.getAnySwitches(), ",");
                int anySwitches = Switch.toValue(query.getAnySwitches());
                predicates.add(builder.gt(builder.function(Functions.BITWISE_AND, Integer.class, root.<Integer>get(SWITCHES), builder.literal(anySwitches)), 0));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<CompanyTenantRel> queryOneSpecification(Query query) {
        Specification<CompanyTenantRel> specification = (Specification<CompanyTenantRel>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get(TENANT_ID), query.getTenantId()));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                predicates.add(builder.equal(root.<Long>get(COMPANY_ID), query.getCompanyId()));
            }
            if (StringUtils.isNotBlank(query.getCompanyCode()) || StringUtils.isNotBlank(query.getTaxNum()) || StringUtils.isNotBlank(query.getCompanyName())) {
                Predicate predicate = builder.disjunction();
                if (StringUtils.isNotBlank(query.getCompanyCode())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(COMPANY_CODE), query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank(query.getTaxNum())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(TAX_NUM), query.getTaxNum()));
                }
                if (StringUtils.isNotBlank(query.getCompanyName())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(COMPANY_NAME), query.getCompanyName()));
                }
                if (predicate != null) {
                    predicates.add(predicate);
                }
            }
            if (StringUtils.isNotBlank(query.getAllSwitches())) {
                String[] switches = StringUtils.split(query.getAllSwitches(), ",");
                int allSwitches = Switch.toValue(query.getAllSwitches());
                predicates.add(builder.equal(builder.function(Functions.BITWISE_AND, Integer.class, root.<Integer>get(SWITCHES), builder.literal(allSwitches)), allSwitches));
            }
            if (StringUtils.isNotBlank(query.getAnySwitches())) {
                String[] switches = StringUtils.split(query.getAnySwitches(), ",");
                int anySwitches = Switch.toValue(query.getAnySwitches());
                predicates.add(builder.gt(builder.function(Functions.BITWISE_AND, Integer.class, root.<Integer>get(SWITCHES), builder.literal(anySwitches)), 0));
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("查询参数不合法");
            } else {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
