package com.xforceplus.query;

import com.xforceplus.api.model.OrgExtensionModel.Request.Query;
import com.xforceplus.entity.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.*;
import java.util.*;

/**
 * @author geewit
 */
@SuppressWarnings("all")
public class OrgExtensionQueryHelper {
    public static Specification<OrgExtension> querySpecification(Query query) {
        return (Specification<OrgExtension>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getOrgStructId() != null && query.getOrgStructId() > 0) {
                predicates.add(builder.equal(root.get("orgStructId"), query.getOrgStructId()));
            }
            if (StringUtils.isNotBlank(query.getOrgName()) || StringUtils.isNotBlank(query.getTenantName()) || StringUtils.isNotBlank(query.getTenantCode())) {
                Join<OrgExtension, OrgStruct> joinOrg = root.join("org", JoinType.LEFT);
                if (StringUtils.isNotBlank(query.getOrgName())) {
                    predicates.add(builder.like(joinOrg.get("orgName"), "%" + query.getOrgName() + "%"));
                }

                if (StringUtils.isNotBlank(query.getTenantName()) || StringUtils.isNotBlank(query.getTenantCode())) {
                    Join<OrgStruct, Tenant> joinTenant = joinOrg.join("tenant", JoinType.LEFT);
                    if (StringUtils.isNotBlank(query.getTenantName())) {
                        predicates.add(builder.like(joinTenant.get("tenantName"), "%" + query.getTenantName() + "%"));
                    }
                    if (StringUtils.isNotBlank(query.getTenantCode())) {
                        predicates.add(builder.like(joinTenant.get("tenantCode"), "%" + query.getTenantCode() + "%"));
                    }
                }
            }
            if (StringUtils.isNotBlank(query.getExtensionKey())) {
                predicates.add(builder.equal(root.get("extensionKey"), query.getExtensionKey()));
            }
            if (StringUtils.isNotBlank(query.getExtensionValue())) {
                predicates.add(builder.equal(root.get("extensionValue"), query.getExtensionValue()));
            }
            if (query.getStatus() == null) {
                query.setStatus(1);
            }
            predicates.add(builder.equal(root.get("status"), query.getStatus()));
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
    }
}
