package com.xforceplus.query;

import com.xforceplus.api.model.OrgVirtualNodeModel;
import com.xforceplus.entity.OrgVirtualNodeUserRel;
import com.xforceplus.entity.User;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

/**
 * 版权：    上海云砺信息科技有限公司
 * author:  duanhy
 * 创建时间: 2020/12/22 11:14
 * 功能描述:
 * 修改历史:
 */
@SuppressWarnings("all")
public class OrgVirtualNodeUserRelQueryHelper {
    public static Specification<OrgVirtualNodeUserRel> querySpecification(OrgVirtualNodeModel.Request.BindedUsers query) {
        Specification<OrgVirtualNodeUserRel> specification = (Specification<OrgVirtualNodeUserRel>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            predicates.add(builder.equal(root.<Long>get("tenantId"), query.getTenantId()));

            if (StringUtils.isNotBlank(query.getUserOptions())) {
                Join<OrgVirtualNodeUserRel, User> joinUser = root.join("user", JoinType.LEFT);
                predicates.add(builder.or(
                        builder.like(joinUser.get("userName"), query.getUserOptions() + "%"),
                        builder.equal(joinUser.<String>get("userCode"), query.getUserOptions()),
                        builder.equal(joinUser.<String>get("userNumber"), query.getUserOptions()),
                        builder.equal(joinUser.<String>get("userPhone"), query.getUserOptions()),
                        builder.equal(joinUser.<String>get("userEmailAddr"), query.getUserOptions())
                ));
            }

            if (null != query.getOrgVirtualNodeId()) {
                predicates.add(builder.equal(root.<Long>get("orgVirtualNodeId"), query.getOrgVirtualNodeId()));
            }
            if (null != query.getUserId()) {
                predicates.add(builder.equal(root.<Long>get("userId"), query.getUserId()));
            }

            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

}
