package com.xforceplus.query;

import com.xforceplus.api.model.OrgVirtualOrgStructRelModel.Request;
import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.api.model.OrgVirtualOrgStructRelModel;
import com.xforceplus.api.model.OrgVirtualOrgStructRelModel.Request.Query;
import com.xforceplus.domain.company.Switch;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.OrgVirtualOrgStructRel;
import com.xforceplus.entity.OrgVirtual;
import com.xforceplus.entity.OrgVirtualNode;
import com.xforceplus.entity.OrgVirtualOrgStructRel;
import com.xforceplus.entity.Tenant;
import io.geewit.data.jpa.essential.function.Functions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

/**
 * @author zhouxin
 * @copyright © 上海云砺信息科技有限公司
 * @date 2021/8/4 11:19
 */
@SuppressWarnings("all")
public class OrgVirtualOrgStructRelQueryHelper {

    public static Specification<OrgVirtualOrgStructRel> querySpecification(
        OrgVirtualOrgStructRelModel.Request.Query query) {
        Specification<OrgVirtualOrgStructRel> specification = (Specification<OrgVirtualOrgStructRel>) (root, criteriaQuery, builder) -> {
            return toPredicate(query, root, criteriaQuery, builder);
        };
        return specification;
    }

    private static <T> Predicate toPredicate(Request.Query query, Root<OrgVirtualOrgStructRel> root,
        CriteriaQuery<T> criteriaQuery, CriteriaBuilder builder) {
        List<Predicate> predicates = new ArrayList<>();
        if (query.getTenantId() != null && query.getTenantId() > 0) {
            predicates.add(builder.equal(root.<Long>get("tenantId"), query.getTenantId()));
        }
        if (query.getOrgVirtualId() != null && query.getOrgVirtualId() > 0) {
            predicates.add(builder.equal(root.<Long>get("orgVirtualId"), query.getOrgVirtualId()));
        }
        if (query.getOrgStructId() != null && query.getOrgStructId() > 0) {
            predicates.add(builder.equal(root.<Long>get("orgStructId"), query.getOrgStructId()));
        }
        if (StringUtils.isNotBlank(query.getOrgStructName())) {
            predicates.add(builder.like(root.<String>get("orgStructName"), query.getOrgStructName() + "%"));
        }

        if (!predicates.isEmpty()) {
            criteriaQuery.where(predicates.stream()
                                          .toArray(Predicate[]::new));
        }
        return criteriaQuery.getRestriction();
    }

    public static Specification<OrgVirtualOrgStructRel> queryOneSpecification(Request.Query query) {
        Specification<OrgVirtualOrgStructRel> specification = (Specification<OrgVirtualOrgStructRel>) (root, criteriaQuery, builder) -> {
            if (null == query.getOrgStructId() || null == query.getOrgVirtualId() || null == query.getTenantId()) {
                throw new IllegalArgumentException("查询参数不合法");
            }
            List<Predicate> predicates = new ArrayList<>();
            predicates.add(builder.equal(root.<Long>get("tenantId"), query.getTenantId()));
            predicates.add(builder.equal(root.<Long>get("orgVirtualId"), query.getOrgVirtualId()));
            predicates.add(builder.equal(root.<Long>get("orgStructId"), query.getOrgStructId()));

            criteriaQuery.where(predicates.stream()
                                          .toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
