package com.xforceplus.query;

import com.xforceplus.api.model.ServicePackageModel.Request.Query;
import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.entity.ServiceResourcesetRel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("all")
public class ServicePackageQueryHelper {
    public static Specification<ServicePackage> querySpecification(Query query) {
        Specification<ServicePackage> specification = (Specification<ServicePackage>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            boolean joinTable = false;
            if ((query.getTenantId() != null && query.getTenantId() > 0) || StringUtils.isNotBlank(query.getTenantCode()) || (query.getCompanyId() != null && query.getCompanyId() > 0)) {
                ListJoin<ServicePackage, CompanyServiceRel> joinCompanyServiceRels = root.joinList("companyServiceRels", JoinType.LEFT);
                if (query.getTenantId() != null && query.getTenantId() > 0) {
                    predicates.add(builder.equal(joinCompanyServiceRels.<Long>get("tenantId"), query.getTenantId()));
                } else if (StringUtils.isNotBlank(query.getTenantCode())) {
                    predicates.add(builder.equal(joinCompanyServiceRels.join("tenant", JoinType.LEFT)
                            .<String>get("tenantCode"), query.getTenantCode()));
                }
                if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                    predicates.add(builder.equal(joinCompanyServiceRels.<Long>get("companyId"), query.getCompanyId()));
                }
                if (query.getStatus() != null) {
                    predicates.add(builder.equal(joinCompanyServiceRels.<Integer>get("status"), query.getStatus()));
                }
                joinTable = true;
            }
            if ((query.getResourcesetId() != null && query.getResourcesetId() > 0) || StringUtils.isNotBlank(query.getResourcesetName()) || StringUtils.isNotBlank(query.getResourcesetCode())) {
                ListJoin<ServicePackage, ServiceResourcesetRel> joinServiceResourcesetRels = root
                        .joinList("serviceResourcesetRels", JoinType.LEFT);
                if (query.getResourcesetId() != null && query.getResourcesetId() > 0) {
                    predicates.add(builder.equal(joinServiceResourcesetRels.<Long>get("resourcesetId"), query.getResourcesetId()));
                }
                if (StringUtils.isNotBlank(query.getResourcesetName()) || StringUtils.isNotBlank(query.getResourcesetCode())) {
                    Join<ServiceResourcesetRel, Resourceset> joinResourceset = joinServiceResourcesetRels.join("resourceset", JoinType.LEFT);
                    if (StringUtils.isNotBlank(query.getResourcesetName())) {
                        predicates.add(builder.like(joinResourceset.get("resourcesetName"), query.getResourcesetName() + "%"));
                    }
                    if (StringUtils.isNotBlank(query.getResourcesetCode())) {
                        predicates.add(builder.like(joinResourceset.get("resourcesetCode"), query.getResourcesetCode() + "%"));
                    }
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal(joinResourceset.get("status"), 1));
                    }
                }
                joinTable = true;
            }

            if (query.getServicePackageId() != null && query.getServicePackageId() > 0) {
                predicates.add(builder.equal(root.<Long>get("servicePackageId"), query.getServicePackageId()));
            }
            if (StringUtils.isNotBlank(query.getServicePackageName())) {
                predicates.add(builder.like(root.get("servicePackageName"), "%" + query.getServicePackageName() + "%"));
            }
            if (StringUtils.isNotBlank(query.getServicePackageCode())) {
                predicates.add(builder.like(root.get("servicePackageCode"), query.getServicePackageCode() + "%"));
            }
            if (query.getAppId() != null && query.getAppId() > 0) {
                predicates.add(builder.equal(root.<Long>get("appId"), query.getAppId()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                } else {
                    criteriaQuery.groupBy(root.<Long>get("servicePackageId"));
                    return criteriaQuery.getGroupRestriction();
                }
            } else {
                return criteriaQuery.getRestriction();
            }
        };
        return specification;
    }

    public static Specification<ServicePackage> queryOneSpecification(Query query) {
        Specification<ServicePackage> specification = (Specification<ServicePackage>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getServicePackageId() != null && query.getServicePackageId() > 0) {
                predicates.add(builder.equal(root.<Long>get("servicePackageId"), query.getServicePackageId()));
            } else {
                if (StringUtils.isNotBlank(query.getServicePackageCode())) {
                    predicates.add(builder.equal(root.<String>get("servicePackageCode"), query.getServicePackageCode()));
                } else {
                    if (StringUtils.isNotBlank(query.getServicePackageName())) {
                        predicates.add(builder.equal(root.<String>get("servicePackageName"), query.getServicePackageName()));
                    }
                    if (query.getAppId() != null && query.getAppId() > 0) {
                        predicates.add(builder.equal(root.<Long>get("appId"), query.getAppId()));
                    }
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
