package com.xforceplus.query;

import com.xforceplus.api.model.TenantCompanyRelModel.Request.Query;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.TenantCompanyRel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("all")
public class TenantCompanyRelQueryHelper {
    /***
     * 公司ID :{@value}
     */
    public static final String COMPANY_ID = "companyId";
    /***
     * 税号字段名 {@value}
     */
    public static final String TAX_NUM = "taxNum";
    /***
     * 公司名称字段 {@value}
     */
    public static final String COMPANY_NAME = "companyName";
    /***
     * 公司代码：{@value}
     */
    public static final String COMPANY_CODE = "companyCode";
    /***
     * 租户ID {@value}
     */
    public static final String TENANT_ID = "tenantId";
    /***
     * 租户Code {@value}
     */
    public static final String TENANT_CODE = "tenantCode";
    /***
     * 租户名称 {@value}
     */
    public static final String TENANT_NAME = "tenantName";
    /***
     * 审核状态 {@value}
     */
    public static final String STATUS = "status";

    public static Specification<TenantCompanyRel> querySpecification(Query query) {
        Specification<TenantCompanyRel> specification = (Specification<TenantCompanyRel>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get(TENANT_ID), query.getTenantId()));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                predicates.add(builder.equal(root.<Long>get(COMPANY_ID), query.getCompanyId()));
            }
            if (StringUtils.isNotBlank(query.getCompanyCode()) || StringUtils.isNotBlank(query.getTaxNum()) || StringUtils.isNotBlank(query.getCompanyName())) {
                Join<TenantCompanyRel, Company> joinCompany = root.join("company", JoinType.LEFT);
                if (StringUtils.isNotBlank(query.getCompanyCode())) {
                    predicates.add(builder.equal(joinCompany.<String>get(COMPANY_CODE), query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank(query.getTaxNum())) {
                    predicates.add(builder.equal(joinCompany.<String>get(TAX_NUM), query.getTaxNum()));
                }
                if (StringUtils.isNotBlank(query.getCompanyName())) {
                    predicates.add(builder.like(joinCompany.get(COMPANY_NAME), query.getCompanyName()));
                }
            }
            if (StringUtils.isNotBlank(query.getTenantName()) || StringUtils.isNotBlank(query.getTenantCode())) {
                Join<TenantCompanyRel, Tenant> joinTenant = root.join("tenant", JoinType.LEFT);
                if (StringUtils.isNotBlank(query.getTenantCode())) {
                    predicates.add(builder.equal(joinTenant.<String>get(TENANT_CODE), query.getTenantCode()));
                }
                if (StringUtils.isNotBlank(query.getTenantName())) {
                    predicates.add(builder.equal(joinTenant.<String>get(TENANT_NAME), query.getTenantName()));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<TenantCompanyRel> queryOneSpecification(Query query) {
        Specification<TenantCompanyRel> specification = (Specification<TenantCompanyRel>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get(TENANT_ID), query.getTenantId()));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                predicates.add(builder.equal(root.<Long>get(COMPANY_ID), query.getCompanyId()));
            }
            if (StringUtils.isNotBlank(query.getCompanyCode()) || StringUtils.isNotBlank(query.getTaxNum()) || StringUtils.isNotBlank(query.getCompanyName())) {
                Predicate predicate = builder.disjunction();
                if (StringUtils.isNotBlank(query.getCompanyCode())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(COMPANY_CODE), query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank(query.getTaxNum())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(TAX_NUM), query.getTaxNum()));
                }
                if (StringUtils.isNotBlank(query.getCompanyName())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(COMPANY_NAME), query.getCompanyName()));
                }
                if (predicate != null) {
                    predicates.add(predicate);
                }
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("查询参数不合法");
            } else {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
