/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.dao.CompanyCustomizedDao;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.entity.Tenant;
import io.geewit.data.jpa.envers.repository.EnversRevisionRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaSpecificationExecutor;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface CompanyDao
extends EntityGraphJpaRepository<Company, Long>,
EntityGraphJpaSpecificationExecutor<Company>,
EnversRevisionRepository<Company, Long, String>,
CompanyCustomizedDao {
    @Modifying(clearAutomatically=true)
    @Query(value="delete from Company c where c.companyId = :companyId")
    public void deleteById(@Param(value="companyId") Long var1);

    @Query(value="select new com.xforceplus.entity.ServicePackage(sp.servicePackageId, sp.servicePackageName, sp.appId) from com.xforceplus.entity.CompanyServiceRel csr left join com.xforceplus.entity.ServicePackage sp on sp.servicePackageId = csr.servicePackageId where csr.companyId = :companyId")
    public List<ServicePackage> findPackagesByCompanyId(@Param(value="companyId") long var1);

    @Query(value="select count(c.companyId) from Company c where (c.companyCode = :companyCode or c.taxNum = :taxNum ) and c.companyId <> :companyId ")
    public long validateExistCompany(@Param(value="companyId") long var1, @Param(value="companyCode") String var3, @Param(value="taxNum") String var4);

    public List<Company> findByTaxNum(@Param(value="taxNum") String var1);

    @Query(value="select count(c.companyId) from Company c where (c.companyCode = :companyCode or c.taxNum = :taxNum ) ")
    public long validateExistCompany(@Param(value="companyCode") String var1, @Param(value="taxNum") String var2);

    @Query(value="select o.tenant_id, o.company_id from sys_org_struct o LEFT JOIN (select rel.tenant_id, rel.company_id from bss_tenant_company_rel rel) as r ON o.tenant_id = r.tenant_id and o.company_id = r.company_id where r.tenant_id is null and r.company_id is null and o.tenant_id > 0 and o.company_id > 0  group by o.tenant_id, o.company_id", nativeQuery=true)
    public List<Map<String, Object>> findFixingCompanies();

    @Query(value="select count(ca.revision) from bss_company_audit ca where ca.company_name = :companyName and ca.tax_num = :taxNum and ca.is_effective = 1", nativeQuery=true)
    public long countAuditByTaxNumAndCompanyName(@Param(value="taxNum") String var1, @Param(value="companyName") String var2);

    @Query(value="select count(ca.revision) from bss_company_audit ca where ca.company_name = :companyName and ca.tax_num = :taxNum and ca.effective_date <= :effectiveDate and ca.is_effective = 1", nativeQuery=true)
    public long countAuditByTaxNumAndCompanyNameAndEffectiveDate(@Param(value="taxNum") String var1, @Param(value="companyName") String var2, @Param(value="effectiveDate") Date var3);

    @Modifying(flushAutomatically=true)
    @Query(value="update bss_company_audit ca set ca.is_effective = :effective where ca.company_id = :companyId and ca.revision = :revision", nativeQuery=true)
    public int updateAuditEffective(@Param(value="companyId") long var1, @Param(value="revision") long var3, @Param(value="effective") boolean var5);

    @Query(value="select c.company_id from bss_company c where c.tax_num = :taxNum", nativeQuery=true)
    public Optional<Long> findIdByTaxNum(@Param(value="taxNum") String var1);

    @Query(value="select c from Company c where c.companyId in (:ids)")
    public List<Company> findByIds(@Param(value="ids") List<Long> var1);

    @Query(value="select c from Company c where c.taxNum = :taxNum and c.companyName = :companyName")
    public Company findByTaxNumAndCompanyName(@Param(value="taxNum") String var1, @Param(value="companyName") String var2);

    @Query(value="select c.hostTenant from Company c where c.companyId = :companyId")
    public Tenant findHostTenantByCompanyId(@Param(value="companyId") long var1);

    @Query(value="select c from Company c where c.companyId = :companyId and c.hostTenantId = :hostTenantId")
    public Company findByCompanyIdAndHostTenantId(@Param(value="companyId") long var1, @Param(value="hostTenantId") long var3);
}

