/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.dao.OrgStructCustomizedDao;
import com.xforceplus.domain.tenant.GradingRoleOrg;
import com.xforceplus.dto.org.CompanyTenantDto;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.OrgStruct;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaSpecificationExecutor;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface OrgStructDao
extends EntityGraphJpaRepository<OrgStruct, Long>,
EntityGraphJpaSpecificationExecutor<OrgStruct>,
JpaBatchExecutor<OrgStruct>,
OrgStructCustomizedDao {
    @Modifying(clearAutomatically=true)
    @Query(value="delete from OrgStruct o where o.orgId = :orgId")
    public void deleteById(@Param(value="orgId") Long var1);

    @EntityGraph(value="Org.graph", type=EntityGraph.EntityGraphType.FETCH)
    @Query(value="select o from OrgStruct o where o.tenantId = :tenantId and o.orgCode = :orgCode")
    public List<OrgStruct> findByTenantIdAndOrgCode(@Param(value="tenantId") long var1, @Param(value="orgCode") String var3);

    @EntityGraph(value="Org.graph", type=EntityGraph.EntityGraphType.FETCH)
    @Query(value="select o from OrgStruct o where o.tenantId = :tenantId and o.orgCode in :orgCodes")
    public List<OrgStruct> findByTenantIdAndOrgCodes(@Param(value="tenantId") long var1, @Param(value="orgCodes") Collection<String> var3);

    @EntityGraph(value="Org.graph.simple", type=EntityGraph.EntityGraphType.FETCH)
    @Query(value="select o from OrgStruct o where o.tenantId = :tenantId and (o.parentId is null or o.parentId = 0)")
    public List<OrgStruct> findRootsByTenantId(@Param(value="tenantId") long var1);

    @Query(value="select o.org_struct_id from sys_org_struct o where o.tenant_id = :tenantId and o.status = 1 and (o.parent_id is null or o.parent_id = 0)", nativeQuery=true)
    public List<Long> findRootIdsByTenantId(@Param(value="tenantId") long var1);

    @Query(value="select o.company from OrgStruct o where o.tenantId = :tenantId")
    public List<Company> findCompaniesByTenantId(@Param(value="tenantId") long var1);

    @Query(value="select count(distinct o.companyId) from OrgStruct o where o.tenantId =:tenantId and o.orgType = :#{T(com.xforceplus.tenant.security.core.domain.OrgType).COMPANY} and o.companyId > 0")
    public int countCompaniesByTenantId(@Param(value="tenantId") long var1);

    @Query(value="select o.org_struct_id from sys_org_struct o where o.tenant_id = :tenantId and o.org_code = :orgCode", nativeQuery=true)
    public Long findIdByTenantIdAndCode(@Param(value="tenantId") long var1, @Param(value="orgCode") String var3);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgStruct o set o.status = 1, o.enabledTime = current_timestamp where o.orgId = :orgId")
    public int enable(@Param(value="orgId") long var1);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgStruct o set o.status = 0, o.disabledTime = current_timestamp where o.orgId = :orgId")
    public int disable(@Param(value="orgId") long var1);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgStruct o set o.status = 1, o.enabledTime = current_timestamp where o.orgId = :orgId and o.tenantId = :tenantId")
    public int enable(@Param(value="tenantId") long var1, @Param(value="orgId") long var3);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgStruct o set o.status = 0, o.disabledTime = current_timestamp where o.orgId = :orgId and o.tenantId = :tenantId")
    public int disable(@Param(value="tenantId") long var1, @Param(value="orgId") long var3);

    @Query(value="select o.org_struct_id from sys_org_struct o where o.tenant_id = :tenantId and o.org_struct_id in :orgIds", nativeQuery=true)
    public List<Long> findOrgIdsByTenantIdAndOrgIds(@Param(value="tenantId") long var1, @Param(value="orgIds") Collection<Long> var3);

    @Query(value="select o.parent_ids from sys_org_struct o where o.org_struct_id =:orgId", nativeQuery=true)
    public String findParentIdsByOrgId(@Param(value="orgId") long var1);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgStruct o set o.companyId = :companyId, o.status = :status, o.auditStatus = :auditStatus, o.enabledTime = current_timestamp where o.orgId = :orgId")
    public void approve(@Param(value="orgId") long var1, @Param(value="companyId") long var3, @Param(value="status") int var5, @Param(value="auditStatus") int var6);

    @EntityGraph(value="Org.graph.simple", type=EntityGraph.EntityGraphType.FETCH)
    @Query(value="select o from OrgStruct o where o.tenantId = :tenantId")
    public List<OrgStruct> findByTenantId(@Param(value="tenantId") long var1);

    @Query(value="select count(o.org_struct_id) from sys_org_struct o where o.parent_id = :orgId and o.status = 1", nativeQuery=true)
    public long countChildren(@Param(value="orgId") long var1);

    @Query(value="select o.org_struct_id from sys_org_struct o where o.tenant_id = :tenantId and o.org_struct_id = :orgId", nativeQuery=true)
    public Long findOrgIdByTenantIdAndOrgId(@Param(value="tenantId") long var1, @Param(value="orgId") long var3);

    @Query(value="select o from OrgStruct o where o.tenantId = :tenantId and o.status = 1")
    public List<OrgStruct> findOrgsByTenantId(@Param(value="tenantId") long var1);

    @Query(value="select o.org_struct_id from sys_org_struct o where o.tenant_id = :tenantId and o.org_code = :orgCode", nativeQuery=true)
    public List<Long> findOrgIdByTenantIdAndOrgCode(@Param(value="tenantId") long var1, @Param(value="orgCode") String var3);

    @Query(value="select o.parent_ids from sys_org_struct o where o.org_struct_id in :orgIds", nativeQuery=true)
    public Set<String> findParentIdsByOrgIds(@Param(value="orgIds") Collection<Long> var1);

    @Query(value="select o.parent_ids from sys_org_struct o where o.org_code = :orgCode", nativeQuery=true)
    public Set<String> findParentIdsByOrgCode(@Param(value="orgCode") String var1);

    @Query(value="select o.org_struct_id from sys_org_struct o where o.parent_ids like :parentIds and o.status = 1", nativeQuery=true)
    public Set<Long> findOrgIdsByParentIdsLike(@Param(value="parentIds") String var1);

    @Query(value="select count(o) from OrgStruct o where o.parentId = :parentId and o.companyId = :companyId")
    public long countCompaniesByParentIdAndCompanyId(@Param(value="parentId") long var1, @Param(value="companyId") long var3);

    public List<OrgStruct> findByCompanyId(Long var1);

    @Query(value="select o.company from OrgStruct o where o.tenantId = :tenantId and o.company.taxNum = :taxNum and o.company.companyName = :companyName")
    public List<Company> findCompaniesByTenantIdAndCompanyNameAndTaxNum(@Param(value="tenantId") long var1, @Param(value="companyName") String var3, @Param(value="taxNum") String var4);

    @Query(value="select o.company from OrgStruct o where o.tenantId = :tenantId and o.companyId = :companyId and o.orgType = :#{T(com.xforceplus.tenant.security.core.domain.OrgType).COMPANY}")
    public Company findCompanyByTenantIdAndCompanyId(@Param(value="tenantId") long var1, @Param(value="companyId") long var3);

    @Query(value="select o.orgId from OrgStruct o where o.tenantId = :tenantId and o.companyId = :companyId")
    public List<Long> findIdByTenantIdAndCompanyId(@Param(value="tenantId") long var1, @Param(value="companyId") long var3);

    @Modifying(clearAutomatically=true)
    @Query(value="update OrgStruct o set o.status = 0 where o.orgId in (:orgIds)")
    public void disableByIds(@Param(value="orgIds") Collection<Long> var1);

    @Query(value="select o.parentIds from OrgStruct o where o.tenantId = :tenantId and o.orgCode in :orgCodes")
    public List<String> findParentIdsByTenantIdAndOrgCodes(@Param(value="tenantId") long var1, @Param(value="orgCodes") Collection<String> var3);

    @Query(value="select o from OrgStruct o where o.parentIds like :parentIds")
    public List<OrgStruct> findChildrenByParentIds(@Param(value="parentIds") String var1);

    @Query(value="select o from OrgStruct o where o.tenantId = :tenantId and o.orgId in :orgIds and o.status = 1")
    public List<OrgStruct> findOrgByTenantIdAndOrgIds(@Param(value="tenantId") long var1, @Param(value="orgIds") Collection<Long> var3);

    @Query(value="select o from OrgStruct o where o.tenantId = :tenantId and o.orgCode in :orgCodes and o.status = 1")
    public List<OrgStruct> findOrgByTenantIdAndOrgCodes(@Param(value="tenantId") long var1, @Param(value="orgCodes") Collection<String> var3);

    @Query(value="select count(o) from OrgStruct o where o.tenantId = :tenantId and o.orgCode = :orgCode")
    public long countByTenantIdAndOrgCode(@Param(value="tenantId") long var1, @Param(value="orgCode") String var3);

    @Query(value="select new org.apache.commons.lang3.tuple.MutablePair(o.orgId, count(child.orgId)) from OrgStruct o left join OrgStruct child on child.parentId = o.orgId where o.orgId in :orgIds and child.status = 1 group by o.orgId")
    public List<Pair<Long, Long>> findChildrenCountMapsByOrgIds(@Param(value="orgIds") Collection<Long> var1);

    @Query(value="select new com.xforceplus.dto.org.CompanyTenantDto(o.tenantId, o.tenant.tenantName, o.tenant.tenantCode, o.companyId) from OrgStruct o where o.companyId = :companyId and o.status = 1 and o.tenant.status = 1 group by o.tenantId")
    public List<CompanyTenantDto> findTenantInfoByCompanyId(@Param(value="companyId") long var1);

    public boolean existsByTenantIdAndOrgId(long var1, long var3);

    @Query(value="select new com.xforceplus.domain.tenant.GradingRoleOrg(o.orgId, o.gradingRoleId, o.orgName) from OrgStruct o where o.gradingRoleId in :roleIds")
    public List<GradingRoleOrg> findOrgsByGradingRoleIds(@Param(value="roleIds") Set<Long> var1);

    @Query(value="select o.parentIds from OrgStruct o where o.gradingRoleId in :roleIds")
    public List<String> listParentIdsByGradingRoleIds(@Param(value="roleIds") Collection<Long> var1);

    @Modifying(clearAutomatically=true)
    @Query(value="update OrgStruct o set o.defaultOrgRoleId = null where o.tenantId = :tenantId and o.defaultOrgRoleId = :roleId")
    public void unSetOrgStructDefaultOrgRole(@Param(value="tenantId") long var1, @Param(value="roleId") Long var3);
}

