/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.entity.OrgUserRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface OrgUserRelDao
extends JpaRepository<OrgUserRel, Long>,
JpaSpecificationExecutor<OrgUserRel>,
JpaBatchExecutor<OrgUserRel> {
    @Modifying(clearAutomatically=true)
    @Query(value="delete from OrgUserRel rel where rel.id = :id")
    public void deleteById(@Param(value="id") Long var1);

    @Query(value="select rel from OrgUserRel rel where rel.userId = :userId")
    public List<OrgUserRel> findByUserId(@Param(value="userId") long var1);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from OrgUserRel rel where rel.tenantId = :tenantId and rel.userId = :userId and rel.orgStructId in :orgIds")
    public void deleteByTenantIdAndUserIdAndOrgIds(@Param(value="tenantId") long var1, @Param(value="userId") long var3, @Param(value="orgIds") Collection<Long> var5);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from OrgUserRel rel where rel.userId = :userId")
    public void deleteByUserId(@Param(value="userId") long var1);

    @Query(value="select rel.orgStructId from OrgUserRel rel where rel.userId = :userId")
    public List<Long> findOrgIdsByUserId(@Param(value="userId") long var1);

    public List<OrgUserRel> findByTenantId(Long var1);

    @Query(value="select rel from OrgUserRel rel where rel.tenantId = :tenantId and rel.orgStructId in :orgIds")
    public Set<OrgUserRel> findRelsByTenantIdAndOrgIds(@Param(value="tenantId") long var1, @Param(value="orgIds") Collection<Long> var3);

    @Query(value="select rel from OrgUserRel rel where rel.orgStructId in :orgIds")
    public Set<OrgUserRel> findRelsByOrgIds(@Param(value="orgIds") Collection<Long> var1);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgUserRel rel set rel.tenantId = :tenantId where rel.id in :orgUserRelIds")
    public void batchUpdateTenant(@Param(value="orgUserRelIds") List<Long> var1, @Param(value="tenantId") Long var2);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from OrgUserRel rel where rel.orgStructId in :orgIds")
    public void deleteByOrgIds(@Param(value="orgIds") Set<Long> var1);

    @Query(value="select count(rel.user_id) from sys_org_user_rel rel where rel.org_struct_id = :orgId", nativeQuery=true)
    public long countByOrgId(@Param(value="orgId") long var1);

    @Query(value="select rel.userId from OrgUserRel rel where rel.tenantId = :tenantId and rel.orgStructId = :orgId")
    public Set<Long> findUserIdByTenantIdAndOrgId(@Param(value="tenantId") long var1, @Param(value="orgId") long var3);
}

