/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.entity.Resourceset;
import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ResourcesetDao
extends JpaRepository<Resourceset, Long>,
JpaSpecificationExecutor<Resourceset> {
    @Modifying(clearAutomatically=true)
    @Query(value="delete from Resourceset rs where rs.resourcesetId = :resourcesetId")
    public void deleteById(@Param(value="resourcesetId") Long var1);

    @Query(value="select rs.resourcesetId from Resourceset rs where rs.resourcesetCode = :resourcesetCode")
    public Long findByResourcesetCode(@Param(value="resourcesetCode") String var1);

    @Query(value="select count(rs) from Resourceset rs where rs.resourcesetId <> :resourcesetId and rs.resourcesetCode = :resourcesetCode")
    public long countByNotCurrentResourcesetIdAndCode(@Param(value="resourcesetId") long var1, @Param(value="resourcesetCode") String var3);

    @Query(value="select count(rs) from Resourceset rs where rs.resourcesetId <> :resourcesetId and rs.resourcesetName = :resourcesetName")
    public long countByNotCurrentResourcesetIdAndName(@Param(value="resourcesetId") long var1, @Param(value="resourcesetName") String var3);

    @Query(value="select ten from Resourceset ten where ten.resourcesetCode = :resourceSetCode")
    public List<Resourceset> findByCode(@Param(value="resourceSetCode") String var1);

    @Query(value="select rel.resourceset_id from bss_service_resourceset_rel rel LEFT JOIN bss_service_package sp ON sp.service_package_id = rel.service_package_id where rel.service_package_id in :packageIds and sp.status = 1", nativeQuery=true)
    public List<Long> findResourcesetIdsByPackageIds(@Param(value="packageIds") Collection<Long> var1);

    @Query(value="select rel.resouseset_id from sys_role_resourceset_rel rel LEFT JOIN sys_role r ON r.role_id = rel.role_id where rel.role_id in :roleIds and r.status = 1", nativeQuery=true)
    public List<Long> findResourcesetIdsByRoleIds(@Param(value="roleIds") Collection<Long> var1);

    @Query(value="from Resourceset where resourcesetId in :resourcesetIds")
    public List<Resourceset> findByResourcesetIds(@Param(value="resourcesetIds") List<Long> var1);
}

