/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.entity.RoleUserRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface RoleUserRelDao
extends JpaRepository<RoleUserRel, Long>,
JpaSpecificationExecutor<RoleUserRel>,
JpaBatchExecutor<RoleUserRel> {
    @Modifying(clearAutomatically=true)
    @Query(value="delete from RoleUserRel rel where rel.id = :id")
    public void deleteById(@Param(value="id") Long var1);

    public List<RoleUserRel> findByRoleId(long var1);

    public List<RoleUserRel> findByUserId(long var1);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from RoleUserRel rel where rel.tenantId = :tenantId and rel.userId = :userId and rel.roleId = :roleId")
    public void deleteByTenantIdAndUserIdAndRoleId(@Param(value="tenantId") long var1, @Param(value="userId") long var3, @Param(value="roleId") Long var5);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from RoleUserRel rel where rel.userId = :userId")
    public void deleteByUserId(@Param(value="userId") long var1);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from RoleUserRel rel where rel.roleId = :roleId")
    public void deleteByRoleId(@Param(value="roleId") long var1);

    public long countByRoleId(long var1);

    public List<RoleUserRel> findByTenantId(Long var1);

    @Modifying(flushAutomatically=true)
    @Query(value="update RoleUserRel rel set rel.tenantId = :tenantId where rel.id in (:roleUserRelIds)")
    public void batchUpdateTenant(@Param(value="roleUserRelIds") List<Long> var1, @Param(value="tenantId") Long var2);

    public List<RoleUserRel> findByRoleIdAndTenantId(long var1, long var3);

    @Query(value="select rel.userId from RoleUserRel rel where rel.roleId = :roleId")
    public List<Long> findUserIdsByRoleId(@Param(value="roleId") Long var1);

    @Query(value="select rel.roleId from RoleUserRel rel inner join com.xforceplus.entity.Role r on rel.roleId = r.id where rel.userId = :userId and r.type = 1")
    public Set<Long> findGradingRoleIdsByUserId(@Param(value="userId") Long var1);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from RoleUserRel rel where rel.roleId = :roleId and rel.userId in :userIds")
    public void deleteByRoleIdAndUserIds(@Param(value="roleId") long var1, @Param(value="userIds") Collection<Long> var3);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from RoleUserRel rel where rel.tenantId = :tenantId and rel.userId = :userId and rel.roleId in :roleIds")
    public void deleteByTenantIdAndUserIdAndRoleIds(@Param(value="tenantId") long var1, @Param(value="userId") long var3, @Param(value="roleIds") Collection<Long> var5);

    @Modifying(clearAutomatically=true)
    @Query(value="update RoleUserRel rel set rel.roleId = :newRoleId where rel.roleId = :existRoleId")
    public void updateRoleId(@Param(value="existRoleId") long var1, @Param(value="newRoleId") long var3);
}

