/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao.impl;

import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.dao.CompanyCustomizedDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.domain.company.CompanyHisDTO;
import com.xforceplus.domain.company.CompanyPackage;
import com.xforceplus.dto.company.CompanyServicePackageDTO;
import com.xforceplus.entity.Company;
import com.xforceplus.query.CompanyQueryHelper;
import io.geewit.data.jpa.essential.utils.TupleQueryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class CompanyCustomizedDaoImpl
extends AbstractDefaultJpaRepositoryImpl
implements CompanyCustomizedDao {
    private static final Logger logger = LoggerFactory.getLogger(CompanyCustomizedDaoImpl.class);
    private static final String SQL_SERVICE_PACKAGE_BY_COMPANY_IDS = "select bcsr.company_id, bsp.service_package_id, bsp.service_package_name from bss_company_service_rel bcsr, bss_service_package bsp where bcsr.service_package_id = bsp.service_package_id and bcsr.company_id in :companyIds";
    private static final int EFFECTIVE_VALID = 1;
    private static final String SQL_COMPANY_HIS_TAX_NUM_PAGE = "select bc.* from bss_company bc where bc.company_id in  (select company_id from bss_company_audit bca where bca.is_effective=:effective and bca.tax_num = :taxNum)";
    private static final String SQL_COMPANY_HIS_BY_TAX_NUM = "select bca.company_id, bca.company_name, bca.tax_num, bca.effective_date, bca.is_effective as effective from bss_company_audit bca where bca.tax_num = :taxNum";

    @Override
    public Page<CompanyPackage> findPackages(CompanyModel.Request.CompanyPackageQuery query, Pageable pageable) {
        StringBuilder selectBuilder = new StringBuilder("select new com.xforceplus.domain.company.CompanyPackage(csr.id, csr.tenantId, csr.tenant.tenantCode, csr.tenant.tenantName, csr.companyId, csr.company.companyName, csr.company.taxNum, csr.status, csr.createUserName, csr.createTime) from com.xforceplus.entity.CompanyServiceRel csr");
        StringBuilder countBuilder = new StringBuilder("select count(distinct csr.companyId) from com.xforceplus.entity.CompanyServiceRel csr join csr.tenant join csr.company");
        StringBuilder groupByBuilder = new StringBuilder(" group by csr.companyId");
        StringBuilder queryBuilder = new StringBuilder();
        if (query != null) {
            boolean hasParam = false;
            if (query.getCompanyId() != null) {
                queryBuilder.append(" where");
                queryBuilder.append(" csr.companyId = :companyId");
                hasParam = true;
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.company.taxNum = :taxNum");
                hasParam = true;
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.company.companyName like :companyName");
                hasParam = true;
            }
            if (query.getTenantId() != null) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.tenantId = :tenantId");
                hasParam = true;
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.tenant.tenantCode = :tenantCode");
                hasParam = true;
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.tenant.tenantName like :tenantName");
                hasParam = true;
            }
            if (query.getServicePackageId() != null && query.getServicePackageId() > 0L) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.servicePackage.servicePackageId = :servicePackageId");
                hasParam = true;
            }
            if (StringUtils.isNotBlank((CharSequence)query.getServicePackageName())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.servicePackage.servicePackageName like :servicePackageName");
                hasParam = true;
            }
            if (query.getStatus() != null) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.status = :status");
            }
        }
        selectBuilder.append((CharSequence)queryBuilder).append((CharSequence)groupByBuilder).append(" order by csr.id desc");
        countBuilder.append((CharSequence)queryBuilder);
        String selectHql = selectBuilder.toString();
        logger.info("selectHQL = {}", (Object)selectHql);
        TypedQuery selectQuery = this.entityManager.createQuery(selectHql, CompanyPackage.class);
        String countHql = countBuilder.toString();
        logger.info("countHQL = {}", (Object)countHql);
        TypedQuery countQuery = this.entityManager.createQuery(countHql, Long.class);
        if (query != null) {
            if (query.getCompanyId() != null) {
                selectQuery.setParameter("companyId", (Object)query.getCompanyId());
                countQuery.setParameter("companyId", (Object)query.getCompanyId());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                selectQuery.setParameter("taxNum", (Object)query.getTaxNum());
                countQuery.setParameter("taxNum", (Object)query.getTaxNum());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                selectQuery.setParameter("companyName", (Object)(query.getCompanyName() + "%"));
                countQuery.setParameter("companyName", (Object)(query.getCompanyName() + "%"));
            }
            if (query.getTenantId() != null) {
                selectQuery.setParameter("tenantId", (Object)query.getTenantId());
                countQuery.setParameter("tenantId", (Object)query.getTenantId());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                selectQuery.setParameter("tenantCode", (Object)query.getTenantCode());
                countQuery.setParameter("tenantCode", (Object)query.getTenantCode());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                selectQuery.setParameter("tenantName", (Object)(query.getTenantName() + "%"));
                countQuery.setParameter("tenantName", (Object)(query.getTenantName() + "%"));
            }
            if (query.getServicePackageId() != null && query.getServicePackageId() > 0L) {
                selectQuery.setParameter("servicePackageId", (Object)query.getServicePackageId());
                countQuery.setParameter("servicePackageId", (Object)query.getServicePackageId());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getServicePackageName())) {
                selectQuery.setParameter("servicePackageName", (Object)("%" + query.getServicePackageName() + "%"));
                countQuery.setParameter("servicePackageName", (Object)("%" + query.getServicePackageName() + "%"));
            }
            if (query.getStatus() != null) {
                selectQuery.setParameter("status", (Object)query.getStatus());
                countQuery.setParameter("status", (Object)query.getStatus());
            }
        }
        long totalCount = (Long)countQuery.getSingleResult();
        logger.info("totalCount = {}", (Object)totalCount);
        int startIndex = pageable.getPageNumber() * pageable.getPageSize();
        if ((long)startIndex > totalCount) {
            return new PageImpl(new ArrayList(), pageable, totalCount);
        }
        selectQuery.setFirstResult(startIndex);
        selectQuery.setMaxResults(pageable.getPageSize());
        List list = selectQuery.getResultList();
        PageImpl page = new PageImpl(list, pageable, totalCount);
        return page;
    }

    @Override
    public List<CompanyServicePackageDTO> findCompanyServicePackageByCompanyIds(Set<Long> companyIds) {
        Assert.notEmpty(companyIds, (String)"\u516c\u53f8IDS\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        StringQuery stringQuery = StringQuery.builder().query(SQL_SERVICE_PACKAGE_BY_COMPANY_IDS).predicate(true).param("companyIds", companyIds).build();
        return this.findBySql(stringQuery, CompanyServicePackageDTO.class, Boolean.TRUE);
    }

    @Override
    public Page<Tuple> findTuples(CompanyModel.Request.Query query, Pageable pageable) {
        Sort sort;
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery tupleCriteriaQuery = criteriaBuilder.createTupleQuery();
        Root tupleRoot = tupleCriteriaQuery.from(Company.class);
        CompanyQueryHelper.queryTuplePredicate(query, (Root<Company>)tupleRoot, (CriteriaQuery<Tuple>)tupleCriteriaQuery, criteriaBuilder);
        Sort sort2 = sort = pageable.isPaged() ? pageable.getSort() : Sort.unsorted();
        if (sort.isSorted()) {
            List toOrders;
            ArrayList orders = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)tupleCriteriaQuery.getOrderList())) {
                orders.addAll(tupleCriteriaQuery.getOrderList());
            }
            if (!CollectionUtils.isEmpty((Collection)(toOrders = QueryUtils.toOrders((Sort)sort, (From)tupleRoot, (CriteriaBuilder)criteriaBuilder)))) {
                orders.addAll(toOrders);
            }
            if (!CollectionUtils.isEmpty(orders)) {
                tupleCriteriaQuery.orderBy(orders);
            }
        }
        TypedQuery listQuery = this.entityManager.createQuery(tupleCriteriaQuery);
        if (pageable.isPaged()) {
            listQuery.setFirstResult((int)pageable.getOffset());
            listQuery.setMaxResults(pageable.getPageSize());
        }
        List results = listQuery.getResultList();
        CriteriaBuilder countCriteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countCriteriaQuery = countCriteriaBuilder.createQuery(Long.class);
        Root countRoot = countCriteriaQuery.from(Company.class);
        CompanyQueryHelper.queryCountPredicate(query, (Root<Company>)countRoot, (CriteriaQuery<Long>)countCriteriaQuery, countCriteriaBuilder);
        if (pageable.isPaged()) {
            return PageableExecutionUtils.getPage((List)results, (Pageable)pageable, () -> TupleQueryUtils.executeCountQuery((TypedQuery)TupleQueryUtils.getCountQuery((EntityManager)this.entityManager, (Root)countRoot, (CriteriaQuery)countCriteriaQuery, (CriteriaBuilder)countCriteriaBuilder)));
        }
        return new PageImpl(results);
    }

    @Override
    public Optional<Company> findCompanyHistoryByTaxNum(String taxNum) {
        Assert.hasText((String)taxNum, (String)"\u7a0e\u53f7\u4e0d\u4e3a\u7a7a");
        StringQuery stringQuery = StringQuery.builder().query(SQL_COMPANY_HIS_TAX_NUM_PAGE).predicate(true).param("taxNum", taxNum).param("effective", 1).build();
        List<Company> companyList = this.findBySql(stringQuery, Company.class, Boolean.TRUE);
        if (CollectionUtils.isEmpty(companyList)) {
            return Optional.empty();
        }
        return Optional.ofNullable(companyList.get(0));
    }

    @Override
    public Page<CompanyHisDTO> pageHistoryByTaxNum(String taxNum, Pageable pageable) {
        Assert.hasText((String)taxNum, (String)"\u7a0e\u53f7\u4e0d\u4e3a\u7a7a");
        StringQuery stringQuery = StringQuery.builder().query(SQL_COMPANY_HIS_BY_TAX_NUM).predicate(true).param("taxNum", taxNum).build();
        return super.pagingSqlBy(pageable, stringQuery.getQuery(), stringQuery.getParams(), CompanyHisDTO.class, Boolean.TRUE);
    }
}

