/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao.impl;

import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.api.model.OrgVirtualNodeModel;
import com.xforceplus.api.model.TreeModel;
import com.xforceplus.dao.OrgVirtualNodeCustomizedDao;
import com.xforceplus.data.transform.UnderlineToBeanResultTransformer;
import com.xforceplus.domain.orgVirtual.OrgVirtualTreeNode;
import com.xforceplus.entity.OrgVirtualNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class OrgVirtualNodeCustomizedDaoImpl
implements OrgVirtualNodeCustomizedDao {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<OrgVirtualTreeNode> treeNodeList(Long tenantId, Long typeId) {
        StringBuilder selectBuilder = new StringBuilder("select DISTINCT  a.org_virtual_node_id as `key`, b.org_code as orgCode, b.org_name as orgName, b.short_name as shortName, b.org_desc as orgDesc, a.parent_id as pid from sys_org_virtual_node a  left join sys_org_virtual b on a.org_virtual_id=b.org_virtual_id  where a.tenant_id=:tenantId  and a.node_type_id=:typeId  order by a.parent_ids");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", (Object)tenantId);
        selectQuery.setParameter("typeId", (Object)typeId);
        return ((NativeQuery)selectQuery.unwrap(NativeQuery.class)).addScalar("key", (Type)StandardBasicTypes.LONG).addScalar("orgCode", (Type)StandardBasicTypes.STRING).addScalar("orgName", (Type)StandardBasicTypes.STRING).addScalar("shortName", (Type)StandardBasicTypes.STRING).addScalar("orgDesc", (Type)StandardBasicTypes.STRING).addScalar("pid", (Type)StandardBasicTypes.LONG).setResultTransformer(Transformers.aliasToBean(OrgVirtualTreeNode.class)).getResultList();
    }

    @Override
    public List<OrgVirtualNodeModel.Response.ExcelExportModel> listNodeRelAccount(Long tenantId, Long typeId) {
        StringBuilder selectBuilder = new StringBuilder("SELECT  a.org_code, a.org_name, a.short_name, e.username, e.email, e.tel_phone, c.control_flag FROM  sys_org_virtual a  LEFT JOIN sys_org_virtual_node b ON a.org_virtual_id = b.org_virtual_id  LEFT JOIN sys_org_virtual_node_user_rel c ON c.org_virtual_node_id = b.org_virtual_node_id  LEFT JOIN sys_user d on c.user_id = d.user_id  left join sys_sass_account e on e.account_id = d.account_id where b.tenant_id=:tenantId  and b.node_type_id=:typeId ");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", (Object)tenantId);
        selectQuery.setParameter("typeId", (Object)typeId);
        UnderlineToBeanResultTransformer transformer = new UnderlineToBeanResultTransformer(OrgVirtualNodeModel.Response.ExcelExportModel.class);
        return ((NativeQuery)selectQuery.unwrap(NativeQuery.class)).setResultTransformer((ResultTransformer)transformer).getResultList();
    }

    @Override
    public List<OrgVirtualModel.Response.Model> listByUserId(Long typeId, Long userId, Long tenantId) {
        StringBuilder selectBuilder = new StringBuilder("SELECT  b.org_virtual_node_id,  b.parent_id,  b.parent_ids,  c.control_flag,  a.*  FROM  sys_org_virtual a  LEFT JOIN sys_org_virtual_node b ON a.org_virtual_id = b.org_virtual_id  LEFT JOIN sys_org_virtual_node_user_rel c ON b.org_virtual_node_id = c.org_virtual_node_id  WHERE  b.node_type_id =:typeId  AND c.user_id =:userId  AND a.tenant_id =:tenantId order by b.parent_ids");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", (Object)tenantId);
        selectQuery.setParameter("typeId", (Object)typeId);
        selectQuery.setParameter("userId", (Object)userId);
        UnderlineToBeanResultTransformer transformer = new UnderlineToBeanResultTransformer(OrgVirtualModel.Response.Model.class);
        return ((NativeQueryImpl)selectQuery.unwrap(NativeQueryImpl.class)).setResultTransformer((ResultTransformer)transformer).getResultList();
    }

    @Override
    public List<OrgVirtualModel.Response.Model> listByNodeId(OrgVirtualNode node, TreeModel.Scope scope) {
        StringBuilder selectBuilder = new StringBuilder("SELECT  b.org_virtual_node_id,  b.parent_id,  b.parent_ids,  b.node_type_id,  a.*  FROM  sys_org_virtual a  LEFT JOIN sys_org_virtual_node b ON a.org_virtual_id = b.org_virtual_id  WHERE  a.tenant_id =:tenantId  and b.node_type_id=:nodeTypeId");
        switch (scope) {
            case PARENTS: {
                selectBuilder.append(" and b.org_virtual_node_id in (:ids)");
                break;
            }
            case CHILDREN: {
                selectBuilder.append(" AND b.parent_ids LIKE :parentIds");
                break;
            }
        }
        selectBuilder.append(" order by b.parent_ids");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", (Object)node.getTenantId());
        selectQuery.setParameter("nodeTypeId", (Object)node.getNodeTypeId());
        Set<Long> parentIds = this.findNodeIdsByParentIds(node.getParentIds());
        switch (scope) {
            case PARENTS: {
                selectQuery.setParameter("ids", parentIds);
                break;
            }
            case CHILDREN: {
                selectQuery.setParameter("parentIds", (Object)(node.getParentIds() + "%"));
                break;
            }
        }
        UnderlineToBeanResultTransformer transformer = new UnderlineToBeanResultTransformer(OrgVirtualModel.Response.Model.class);
        return ((NativeQueryImpl)selectQuery.unwrap(NativeQueryImpl.class)).setResultTransformer((ResultTransformer)transformer).getResultList();
    }

    @Override
    public List<OrgVirtualModel.Response.Model> listByKeys(Long tenantId, Integer nodeTypeId, boolean byId, Set<String> keySet) {
        StringBuilder selectBuilder = new StringBuilder("SELECT  b.org_virtual_node_id,  b.parent_id,  b.parent_ids,  b.node_type_id,  a.*  FROM  sys_org_virtual a  RIGHT JOIN sys_org_virtual_node b ON a.org_virtual_id = b.org_virtual_id  WHERE  a.tenant_id =:tenantId  and b.node_type_id=:nodeTypeId");
        selectBuilder.append(byId ? " and a.org_virtual_id in (:keySet)" : " and a.org_code in (:keySet)");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", (Object)tenantId);
        selectQuery.setParameter("nodeTypeId", (Object)nodeTypeId);
        selectQuery.setParameter("keySet", keySet);
        UnderlineToBeanResultTransformer transformer = new UnderlineToBeanResultTransformer(OrgVirtualModel.Response.Model.class);
        return ((NativeQueryImpl)selectQuery.unwrap(NativeQueryImpl.class)).setResultTransformer((ResultTransformer)transformer).getResultList();
    }

    private Set<Long> findNodeIdsByParentIds(String parentIds) {
        String[] parentArr = parentIds.split("\\#|\\-|/|%");
        HashSet<Long> parentIdSet = new HashSet<Long>();
        for (String s : parentArr) {
            parentIdSet.add(Long.parseLong(s));
        }
        return parentIdSet;
    }
}

