/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao.impl;

import com.xforceplus.dao.ServicePackageCustomizedDao;
import com.xforceplus.data.transform.UnderlineToBeanResultTransformer;
import com.xforceplus.domain.TreeNode;
import com.xforceplus.domain.resource.ServiceResourceSetResourceDTO;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePackageCustomizedDaoImpl
implements ServicePackageCustomizedDao {
    private static final Logger logger = LoggerFactory.getLogger(ServicePackageCustomizedDaoImpl.class);
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<ServiceResourceSetResourceDTO> tree(Long tenantId) {
        Integer enableStatus = 1;
        StringBuilder selectBuilder = new StringBuilder("select DISTINCT b.service_package_id,b.service_package_name,b.service_package_code ,IF(d.resourceset_code IS NULL,'',d.resourceset_code) resourceset_code,d.resourceset_id,d.resourceset_name ,f.resource_code,f.resource_id,f.resource_name,f.app_id as resource_app_id from bss_company_service_rel a left join bss_service_package b on a.service_package_id=b.service_package_id left join bss_service_resourceset_rel c on b.service_package_id=c.service_package_id left join sys_resourceset d on c.resourceset_id = d.resourceset_id LEFT JOIN sys_resourceset_resource_rel e on d.resourceset_id = e.resourceset_id LEFT JOIN sys_resource f on e.resource_id= f.resource_id where a.tenant_id=:tenantId and a.status=:status and b.status=:status and d.status=:status and f.status=:status");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", (Object)tenantId);
        selectQuery.setParameter("status", (Object)enableStatus);
        ((NativeQueryImpl)selectQuery.unwrap(NativeQueryImpl.class)).setResultTransformer((ResultTransformer)new UnderlineToBeanResultTransformer(ServiceResourceSetResourceDTO.class));
        return selectQuery.getResultList();
    }

    @Override
    public List<TreeNode> treePackageNodeList(Long tenantId) {
        Integer enableStatus = 1;
        StringBuilder selectBuilder = new StringBuilder("select DISTINCT  CONCAT('PG_', b.service_package_id) as `id`, b.service_package_id as `key`, b.service_package_name as title,'PG_0' as  parentKey, 'SERVICE_PACKAGE' as type from bss_company_service_rel a  left join bss_service_package b on a.service_package_id=b.service_package_id  where a.tenant_id=:tenantId  and a.status=:status and b.status=:status ");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", (Object)tenantId);
        selectQuery.setParameter("status", (Object)enableStatus);
        return ((NativeQuery)selectQuery.unwrap(NativeQuery.class)).addScalar("key", (Type)StandardBasicTypes.LONG).addScalar("id", (Type)StandardBasicTypes.STRING).addScalar("title", (Type)StandardBasicTypes.STRING).addScalar("parentKey", (Type)StandardBasicTypes.STRING).addScalar("type", (Type)StandardBasicTypes.STRING).setResultTransformer(Transformers.aliasToBean(TreeNode.class)).getResultList();
    }

    @Override
    public List<TreeNode> treeResourcesetNodeList(Collection<Long> packageServiceIds) {
        Integer enableStatus = 1;
        StringBuilder selectBuilder = new StringBuilder("select DISTINCT CONCAT('RS_', b.resourceset_id) as `id`,b.resourceset_id as `key`,a.resourceset_name as title,b.service_package_id as pid, CONCAT('PG_', b.service_package_id) as `parentKey`,'RESOURCE_SET' as type from sys_resourceset a  left join bss_service_resourceset_rel b on a.resourceset_id=b.resourceset_id  where b.service_package_id in (:packageServiceIds ) and a.status=:status ");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("packageServiceIds", packageServiceIds);
        selectQuery.setParameter("status", (Object)enableStatus);
        return ((NativeQuery)selectQuery.unwrap(NativeQuery.class)).addScalar("key", (Type)StandardBasicTypes.LONG).addScalar("id", (Type)StandardBasicTypes.STRING).addScalar("title", (Type)StandardBasicTypes.STRING).addScalar("pid", (Type)StandardBasicTypes.LONG).addScalar("parentKey", (Type)StandardBasicTypes.STRING).addScalar("type", (Type)StandardBasicTypes.STRING).setResultTransformer(Transformers.aliasToBean(TreeNode.class)).getResultList();
    }

    @Override
    public List<TreeNode> treeResourceNodeList(Collection<Long> resourcesetIds) {
        Integer enableStatus = 1;
        StringBuilder selectBuilder = new StringBuilder("select DISTINCT CONCAT('RC_', b.resource_id) as `id`,b.resource_id as `key`, CONCAT(a.resource_name,'[',a.resource_code,']') AS title, b.resourceset_id as pid,  CONCAT('RS_', b.resourceset_id) as `parentKey`,'RESOURCE' as type from sys_resource a  left join sys_resourceset_resource_rel b on a.resource_id=b.resource_id  where b.resourceset_id in (:resourcesetIds )  and a.status=:status");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("resourcesetIds", resourcesetIds);
        selectQuery.setParameter("status", (Object)enableStatus);
        return ((NativeQuery)selectQuery.unwrap(NativeQuery.class)).addScalar("key", (Type)StandardBasicTypes.LONG).addScalar("id", (Type)StandardBasicTypes.STRING).addScalar("title", (Type)StandardBasicTypes.STRING).addScalar("pid", (Type)StandardBasicTypes.LONG).addScalar("parentKey", (Type)StandardBasicTypes.STRING).addScalar("type", (Type)StandardBasicTypes.STRING).setResultTransformer(Transformers.aliasToBean(TreeNode.class)).getResultList();
    }
}

