/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.data.query;

import com.xforceplus.utils.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;

public class NamedParams {
    public static final String QUERY_VALUE_LIKE_TEXT_ERROR = "Like paramValue must has text";
    private static final String QUERY_NAME_NULL_ERROR = "Query paramName must not be null!";
    private static final String QUERY_VALUE_NULL_ERROR = "Query paramValue must not be null!";
    private static final String QUERY_VALUE_DATE_NULL_ERROR = "Query paramName must not be null!";
    private final Map<String, Object> parameters = new ConcurrentHashMap<String, Object>();

    private NamedParams() {
    }

    public static NamedParams instance() {
        return new NamedParams();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public NamedParams param(String paramName, Object paramValue) {
        Assert.notNull((Object)paramName, (String)"Query paramName must not be null!");
        Assert.notNull((Object)paramValue, (String)QUERY_VALUE_NULL_ERROR);
        this.parameters.put(paramName, paramValue);
        return this;
    }

    public NamedParams paramDateStart(String paramName, Object paramValue) {
        Assert.notNull((Object)paramName, (String)"Query paramName must not be null!");
        Assert.notNull((Object)paramValue, (String)QUERY_VALUE_NULL_ERROR);
        Assert.isInstanceOf(Date.class, (Object)paramValue, (String)"Query paramName must not be null!");
        paramValue = DateUtils.getDateByDayBegin((Date)((Date)paramValue));
        this.parameters.put(paramName, paramValue);
        return this;
    }

    public NamedParams paramDateEnd(String paramName, Object paramValue) {
        Assert.notNull((Object)paramName, (String)"Query paramName must not be null!");
        Assert.notNull((Object)paramValue, (String)QUERY_VALUE_NULL_ERROR);
        Assert.isInstanceOf(Date.class, (Object)paramValue, (String)"Query paramName must not be null!");
        paramValue = DateUtils.getDateByDayEnd((Date)((Date)paramValue));
        this.parameters.put(paramName, paramValue);
        return this;
    }

    public NamedParams likeParam(String paramName, Object paramValue) {
        this.validate(paramName, paramValue);
        this.parameters.put(paramName, "%" + this.likeValidate(paramName, paramValue) + "%");
        return this;
    }

    public NamedParams likeStartParam(String paramName, Object paramValue) {
        this.validate(paramName, paramValue);
        this.parameters.put(paramName, this.likeValidate(paramName, paramValue) + "%");
        return this;
    }

    protected void validate(String paramName, Object paramValue) {
        Assert.notNull((Object)paramName, (String)"Query paramName must not be null!");
        Assert.notNull((Object)paramValue, (String)QUERY_VALUE_NULL_ERROR);
    }

    protected String likeValidate(String paramName, Object paramValue) {
        this.validate(paramName, paramValue);
        String value = String.valueOf(paramValue);
        Assert.hasText((String)value, (String)QUERY_VALUE_LIKE_TEXT_ERROR);
        return value;
    }

    public NamedParams likeEndParam(String paramName, Object paramValue) {
        this.validate(paramName, paramValue);
        this.parameters.put(paramName, "%" + this.likeValidate(paramName, paramValue));
        return this;
    }

    public NamedParams inParam(String paramName, Object paramValue) {
        this.validate(paramName, paramValue);
        if (paramValue.getClass().isArray() || paramValue instanceof Collection) {
            this.parameters.put(paramName, paramValue);
        } else {
            ArrayList<Object> paramList = new ArrayList<Object>(2);
            paramList.add(paramValue);
            this.parameters.put(paramName, paramList);
        }
        return this;
    }
}

