/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.data.query;

import com.xforceplus.data.query.NamedParams;
import com.xforceplus.data.query.QueryUtils;
import com.xforceplus.data.query.SortQuery;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;

public class StringQuery {
    private StringBuilder stringQuery = new StringBuilder();
    private NamedParams namedParams = NamedParams.instance();
    private boolean predicate = true;

    private StringQuery() {
    }

    public static StringQuery builder() {
        return new StringQuery();
    }

    public StringQuery query(String query) {
        if (this.predicate) {
            this.stringQuery.append(query);
        }
        return this;
    }

    public StringQuery param(String paramName, Object paramValue) {
        if (this.predicate) {
            this.namedParams.param(paramName, paramValue);
        }
        return this;
    }

    public StringQuery paramDateStart(String paramName, Object paramValue) {
        if (this.predicate) {
            this.namedParams.paramDateStart(paramName, paramValue);
        }
        return this;
    }

    public StringQuery paramDateEnd(String paramName, Object paramValue) {
        if (this.predicate) {
            this.namedParams.paramDateEnd(paramName, paramValue);
        }
        return this;
    }

    public StringQuery likeParam(String paramName, Object paramValue) {
        if (this.predicate) {
            this.namedParams.likeParam(paramName, paramValue);
        }
        return this;
    }

    public StringQuery likeEndParam(String paramName, Object paramValue) {
        if (this.predicate) {
            this.namedParams.likeEndParam(paramName, paramValue);
        }
        return this;
    }

    public StringQuery likeStartParam(String paramName, Object paramValue) {
        if (this.predicate) {
            this.namedParams.likeStartParam(paramName, paramValue);
        }
        return this;
    }

    public StringQuery inParam(String paramName, Object paramValue) {
        if (this.predicate) {
            this.namedParams.inParam(paramName, paramValue);
        }
        return this;
    }

    public StringQuery predicate(boolean predicate) {
        this.predicate = predicate;
        return this;
    }

    public <T extends Serializable> StringQuery predicateNotNull(T o) {
        this.predicate = o != null;
        return this;
    }

    public <T extends Serializable> StringQuery predicateIsNull(T o) {
        this.predicate = o == null;
        return this;
    }

    public StringQuery predicateHasText(String str) {
        this.predicate = StringUtils.isNotBlank((CharSequence)str);
        return this;
    }

    public StringQuery predicateNotHasText(String o) {
        this.predicate = !StringUtils.isNotBlank((CharSequence)o);
        return this;
    }

    public <T extends Serializable> StringQuery predicateNotEmpty(Collection<T> collection) {
        this.predicate = collection != null && !collection.isEmpty();
        return this;
    }

    public <T extends Serializable> StringQuery predicateIsEmpty(Collection<T> collection) {
        this.predicate = collection == null || collection.isEmpty();
        return this;
    }

    public <T extends Serializable> StringQuery predicateNotEmpty(T[] array) {
        this.predicate = array != null && array.length != 0;
        return this;
    }

    public <T extends Serializable> StringQuery predicateIsEmpty(T[] array) {
        this.predicate = array == null || array.length == 0;
        return this;
    }

    public StringQuery sort(Sort sort) {
        if (!this.predicate) {
            return this;
        }
        if (sort == null || !sort.iterator().hasNext()) {
            return this;
        }
        this.stringQuery.append(sort.stream().map(e -> e.getProperty() + " " + e.getDirection()).collect(Collectors.joining(",", " order by ", "")));
        return this;
    }

    public StringQuery sort(Sort sort, SortQuery sortQuery) {
        if (!this.predicate) {
            return this;
        }
        if (sort == null || !sort.iterator().hasNext()) {
            return this;
        }
        String query = sortQuery.query(sort);
        if (!StringUtils.isEmpty((CharSequence)query)) {
            this.stringQuery.append(query);
        }
        return this;
    }

    public StringQuery build() {
        this.predicate = true;
        return this;
    }

    public String getQuery() {
        return QueryUtils.removeWhereInvalidCondition(this.stringQuery);
    }

    public NamedParams getParams() {
        return this.namedParams;
    }
}

