/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.data.repository;

import com.xforceplus.data.query.NamedParams;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.query.StringQueryUtils;
import com.xforceplus.data.transform.UnderlineToBeanResultTransformer;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;

public abstract class AbstractDefaultJpaRepositoryImpl {
    @PersistenceContext
    protected EntityManager entityManager;

    public <S> List<S> findBySql(StringQuery stringQuery, Class<S> clazz) {
        return this.findBySql(stringQuery, clazz, Boolean.FALSE);
    }

    public <S> List<S> findBySql(StringQuery stringQuery, Class<S> clazz, Boolean underline) {
        Query query = this.entityManager.createNativeQuery(stringQuery.getQuery());
        UnderlineToBeanResultTransformer transformer = underline != false ? new UnderlineToBeanResultTransformer(clazz) : new AliasToBeanResultTransformer(clazz);
        this.setQueryParams(query, stringQuery.getParams());
        ((NativeQueryImpl)query.unwrap(NativeQueryImpl.class)).setResultTransformer((ResultTransformer)transformer);
        return query.getResultList();
    }

    public <S> Page<S> pagingSqlBy(Pageable pageable, String sql, NamedParams params, Class<S> clazz) {
        Assert.notNull((Object)sql, (String)"Query must has text!");
        String countSql = StringQueryUtils.genCountQueryString(sql);
        return this.pagingSqlBy(sql, countSql, params, pageable, clazz);
    }

    public <S> Page<S> pagingSqlBy(Pageable pageable, StringQuery stringQuery, Class<S> clazz, Boolean underline) {
        return this.pagingSqlBy(pageable, stringQuery.getQuery(), stringQuery.getParams(), clazz, underline);
    }

    public <S> Page<S> pagingSqlBy(Pageable pageable, String sql, NamedParams params, Class<S> clazz, Boolean underline) {
        Assert.notNull((Object)sql, (String)"Query must has text!");
        String countSql = StringQueryUtils.genCountQueryString(sql);
        return this.pagingSqlBy(sql, countSql, params, pageable, clazz, underline);
    }

    public <S> Page<S> pagingSqlBy(String sql, String countSql, NamedParams params, Pageable pageable, Class<S> clazz, Boolean underline) {
        UnderlineToBeanResultTransformer transformer = underline != false ? new UnderlineToBeanResultTransformer(clazz) : new AliasToBeanResultTransformer(clazz);
        Assert.hasText((String)sql, (String)"Query must has text!");
        Assert.hasText((String)countSql, (String)"Query count must has text!");
        Assert.notNull((Object)params, (String)"QueryParams must not be null!");
        Assert.notNull((Object)pageable, (String)"PageRequest must not be null!");
        Query query = this.entityManager.createNativeQuery(sql);
        this.setQueryParams(query, params);
        ((NativeQueryImpl)query.unwrap(NativeQueryImpl.class)).setResultTransformer((ResultTransformer)transformer);
        query.setMaxResults(pageable.getPageSize());
        query.setFirstResult((int)pageable.getOffset());
        List resultList = query.getResultList();
        Query countQuery = this.entityManager.createNativeQuery(countSql);
        this.setQueryParams(countQuery, params);
        Long total = Long.valueOf(String.valueOf(countQuery.getSingleResult()));
        return new PageImpl(resultList, pageable, total.longValue());
    }

    protected <S> Page<S> pagingSqlBy(String sql, String countSql, NamedParams params, Pageable pageable, Class<S> clazz) {
        return this.pagingSqlBy(sql, countSql, params, pageable, clazz, Boolean.FALSE);
    }

    protected void setQueryParams(Query query, NamedParams params) {
        if (params.isEmpty()) {
            return;
        }
        params.getParameters().forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
    }
}

