/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.company.CompanyTenantRelDto;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@NamedEntityGraphs(value={@NamedEntityGraph(name="CompanyTenantRel.graph", attributeNodes={@NamedAttributeNode(value="company"), @NamedAttributeNode(value="tenant"), @NamedAttributeNode(value="relatedCompany"), @NamedAttributeNode(value="relatedTenant")})})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name="company_tenant_rel")
public class CompanyTenantRel
extends CompanyTenantRelDto {
    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "CompanyTenantRel.graph";
    @JsonIgnore
    private Tenant tenant;
    @JsonIgnore
    private Company company;
    @JsonIgnore
    private Tenant relatedTenant;
    @JsonIgnore
    private Company relatedCompany;
    @JsonIgnore
    private List<OrgStruct> orgs;
    @JsonIgnore
    private List<OrgStruct> relatedOrgs;

    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="SnowflakeGenerator")
    @GenericGenerator(name="SnowflakeGenerator", strategy="io.geewit.data.jpa.essential.id.SnowflakeGenerator")
    public Long getId() {
        return this.id;
    }

    @Basic
    @Column(name="inviting_company_id", updatable=false)
    public Long getInvitingCompanyId() {
        return this.invitingCompanyId;
    }

    @Basic
    @Column(name="inviting_company_name", updatable=false)
    public String getInvitingCompanyName() {
        return this.invitingCompanyName;
    }

    @Basic
    @Column(name="tenant_id", updatable=false)
    public Long getTenantId() {
        return this.tenantId;
    }

    @Basic
    @Column(name="company_id", updatable=false)
    public Long getCompanyId() {
        return this.companyId;
    }

    @Basic
    @Column(name="related_tenant_id", updatable=false)
    public Long getRelatedTenantId() {
        return this.relatedTenantId;
    }

    @Basic
    @Column(name="related_company_id", updatable=false)
    public Long getRelatedCompanyId() {
        return this.relatedCompanyId;
    }

    @Basic
    @Column(name="switches")
    public Integer getSwitches() {
        return this.switches;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="statement_start_date")
    public Date getStatementStartDate() {
        return this.statementStartDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="statement_granted_time")
    public Date getStatementGrantedTime() {
        return this.statementGrantedTime;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="invoice_start_date")
    public Date getInvoiceStartDate() {
        return this.invoiceStartDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="invoice_granted_time")
    public Date getInvoiceGrantedTime() {
        return this.invoiceGrantedTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="create_time", updatable=false)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="update_time")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tenant_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return this.tenant;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="company_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public Company getCompany() {
        return this.company;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="related_tenant_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public Tenant getRelatedTenant() {
        return this.relatedTenant;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="related_company_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public Company getRelatedCompany() {
        return this.relatedCompany;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="tenant_id", referencedColumnName="tenant_id", insertable=false, updatable=false), @JoinColumn(name="company_id", referencedColumnName="company_id", insertable=false, updatable=false)}, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public List<OrgStruct> getOrgs() {
        return this.orgs;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="related_tenant_id", referencedColumnName="tenant_id", insertable=false, updatable=false), @JoinColumn(name="company_id", referencedColumnName="company_id", insertable=false, updatable=false)}, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public List<OrgStruct> getRelatedOrgs() {
        return this.relatedOrgs;
    }

    @JsonIgnore
    @Transient
    public void fillTenant() {
        if (this.tenant != null) {
            this.tenantCode = this.tenant.getTenantCode();
            this.tenantName = this.tenant.getTenantName();
        } else {
            this.tenantId = null;
        }
    }

    @JsonIgnore
    @Transient
    public void fillHostTenant(TenantDto hostTenant) {
        if (hostTenant != null) {
            this.hostTenantName = hostTenant.getTenantName();
            this.hostTenantCode = hostTenant.getTenantCode();
        } else {
            this.hostTenantId = null;
        }
    }

    @JsonIgnore
    @Transient
    public void fillCompany() {
        if (this.company != null) {
            this.companyCode = this.company.getCompanyCode();
            this.companyName = this.company.getCompanyName();
            this.taxNum = this.company.getTaxNum();
        }
    }

    @JsonIgnore
    @Transient
    public void fillRelatedEntity() {
        if (this.relatedTenant != null) {
            this.relatedTenantName = this.relatedTenant.getTenantName();
            this.relatedTenantCode = this.relatedTenant.getTenantCode();
        } else {
            this.relatedTenantId = null;
        }
        if (this.relatedCompany != null) {
            this.relatedCompanyCode = this.relatedCompany.getCompanyCode();
            this.relatedCompanyName = this.relatedCompany.getCompanyName();
            this.relatedTaxNum = this.relatedCompany.getTaxNum();
        } else {
            this.relatedCompanyId = null;
        }
    }

    @JsonIgnore
    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    @JsonIgnore
    public void setCompany(Company company) {
        this.company = company;
    }

    @JsonIgnore
    public void setRelatedTenant(Tenant relatedTenant) {
        this.relatedTenant = relatedTenant;
    }

    @JsonIgnore
    public void setRelatedCompany(Company relatedCompany) {
        this.relatedCompany = relatedCompany;
    }

    @JsonIgnore
    public void setOrgs(List<OrgStruct> orgs) {
        this.orgs = orgs;
    }

    @JsonIgnore
    public void setRelatedOrgs(List<OrgStruct> relatedOrgs) {
        this.relatedOrgs = relatedOrgs;
    }
}

