/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import com.xforceplus.entity.SettleTemplateAttribute;
import io.geewit.web.utils.JsonUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@NamedEntityGraphs(value={@NamedEntityGraph(name="SettleTemplate.graph", attributeNodes={@NamedAttributeNode(value="attributes")})})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name="settle_template")
public class SettleTemplate
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(SettleTemplate.class);
    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "SettleTemplate.graph";
    private Long templateId;
    private String templateName;
    private String rawProperties;
    private String templateCode;
    private Integer pageIndex;
    private List<SettleTemplateAttribute> attributes;
    private List<String> serviceCodes;

    @Basic
    @Column(name="template_code")
    public String getTemplateCode() {
        return this.templateCode;
    }

    @Id
    @Column(name="template_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="SnowflakeGenerator")
    @GenericGenerator(name="SnowflakeGenerator", strategy="io.geewit.data.jpa.essential.id.SnowflakeGenerator")
    public Long getTemplateId() {
        return this.templateId;
    }

    @Basic
    @Column(name="template_name")
    public String getTemplateName() {
        return this.templateName;
    }

    @Basic
    @Column(name="properties")
    public String getRawProperties() {
        return this.rawProperties;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="template_id", insertable=false, updatable=false, referencedColumnName="template_id", foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public List<SettleTemplateAttribute> getAttributes() {
        return this.attributes;
    }

    @Transient
    public List<String> getServiceCodes() {
        return this.serviceCodes;
    }

    @Transient
    public Integer getPageIndex() {
        return this.pageIndex;
    }

    @Transient
    public Map<String, String> geProperties(Map<String, String> flowProperties) {
        if (this.rawProperties != null) {
            try {
                Map properties = (Map)JsonUtils.fromJson((String)this.rawProperties, (TypeReference)new TypeReference<Map<String, String>>(){});
                if (flowProperties == null) {
                    flowProperties = new HashMap<String, String>(properties);
                } else {
                    flowProperties.putAll(properties);
                }
                return flowProperties;
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return new HashMap<String, String>(0);
            }
        }
        if (flowProperties == null) {
            return new HashMap<String, String>(0);
        }
        return flowProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettleTemplate that = (SettleTemplate)o;
        return Objects.equals(this.templateId, that.templateId);
    }

    public int hashCode() {
        return Objects.hash(this.templateId);
    }

    public String toString() {
        return "SettleTemplate{templateId=" + this.templateId + ", templateName='" + this.templateName + '\'' + ", rawProperties='" + this.rawProperties + '\'' + '}';
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setRawProperties(String rawProperties) {
        this.rawProperties = rawProperties;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setAttributes(List<SettleTemplateAttribute> attributes) {
        this.attributes = attributes;
    }

    public void setServiceCodes(List<String> serviceCodes) {
        this.serviceCodes = serviceCodes;
    }
}

