/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.tenant.TenantPolicyDto;
import com.xforceplus.entity.Tenant;
import com.xforceplus.jpa.listener.TenantPolicyListener;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@EntityListeners(value={TenantPolicyListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name="tenant_policy")
public class TenantPolicy
extends TenantPolicyDto<Tenant>
implements Serializable {
    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="SnowflakeGenerator")
    @GenericGenerator(name="SnowflakeGenerator", strategy="io.geewit.data.jpa.essential.id.SnowflakeGenerator")
    public Long getId() {
        return this.id;
    }

    @Basic
    @Column(name="tenant_id", nullable=false)
    public Long getTenantId() {
        return this.tenantId;
    }

    @Basic
    @Column(name="name", nullable=false)
    public String getName() {
        return this.name;
    }

    @Basic
    @Column(name="policy", nullable=false)
    public String getPolicy() {
        return this.policy;
    }

    @Basic
    @Column(name="updater_id")
    public String getUpdaterId() {
        return this.updaterId;
    }

    @Basic
    @Column(name="updater_name")
    public String getUpdaterName() {
        return this.updaterName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="update_time")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    @JoinColumn(name="tenant_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return (Tenant)this.tenant;
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        TenantPolicy that = (TenantPolicy)o;
        return this.getTenantId().equals(that.getTenantId()) && this.getName().equals(that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getTenantId(), this.getName());
    }
}

