/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.entity.User;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name="sys_user_tag")
public class UserTag
implements Serializable {
    private Long id;
    private Long userId;
    private String tagName;
    private String tagValue;
    @JsonIgnore
    private User user;

    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="SnowflakeGenerator")
    @GenericGenerator(name="SnowflakeGenerator", strategy="io.geewit.data.jpa.essential.id.SnowflakeGenerator")
    @Column(name="user_tag_id")
    public Long getId() {
        return this.id;
    }

    @Basic
    @Column(name="user_id")
    public Long getUserId() {
        return this.userId;
    }

    @Basic
    @Column(name="tag_name")
    public String getTagName() {
        return this.tagName;
    }

    @Basic
    @Column(name="tag_value")
    public String getTagValue() {
        return this.tagValue;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTag userTag = (UserTag)o;
        return Objects.equals(this.userId, userTag.userId) && Objects.equals(this.tagName, userTag.tagName);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.tagName);
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setTagValue(String tagValue) {
        this.tagValue = tagValue;
    }

    @JsonIgnore
    public void setUser(User user) {
        this.user = user;
    }
}

