/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.entity.Company;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class CompanyQueryHelper {
    public static Specification<Company> querySpecification(CompanyModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> CompanyQueryHelper.toPredicate(query, (Root<Company>)root, criteriaQuery, builder);
        return specification;
    }

    public static Predicate queryTuplePredicate(CompanyModel.Request.Query query, Root<Company> root, CriteriaQuery<Tuple> criteriaQuery, CriteriaBuilder builder) {
        return CompanyQueryHelper.toPredicate(query, root, criteriaQuery, builder);
    }

    public static Predicate queryCountPredicate(CompanyModel.Request.Query query, Root<Company> root, CriteriaQuery<Long> criteriaQuery, CriteriaBuilder builder) {
        return CompanyQueryHelper.toPredicate(query, root, criteriaQuery, builder);
    }

    private static <T> Predicate toPredicate(CompanyModel.Request.Query query, Root<Company> root, CriteriaQuery<T> criteriaQuery, CriteriaBuilder builder) {
        Predicate predicate;
        Set taxNums;
        Set companyCodes;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Class resultType = criteriaQuery.getResultType();
        boolean isCount = resultType.isAssignableFrom(Long.class);
        boolean joinTable = false;
        ListJoin joinOrgs = null;
        if (query.getMultipleTenants() != null) {
            if (resultType.isAssignableFrom(Tuple.class)) {
                criteriaQuery = criteriaQuery.multiselect(new Selection[]{root.alias("company")});
            }
            joinOrgs = root.joinList("orgs", JoinType.LEFT);
            Expression countExpression = builder.count((Expression)joinOrgs.get("orgId"));
            Predicate havingPredicate = query.getMultipleTenants() != false ? builder.gt(countExpression, (Number)1) : builder.equal(countExpression, (Object)1);
            criteriaQuery.having((Expression)havingPredicate);
            joinTable = true;
        }
        if (query.getTenantId() != null && query.getTenantId() > 0L || StringUtils.isNotBlank((CharSequence)query.getTenantName()) || query.getMultipleTenants() != null) {
            if (joinOrgs == null) {
                joinOrgs = root.joinList("orgs", JoinType.LEFT);
            }
            if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)joinOrgs.get("tenantId"), (Object)query.getTenantId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                Join joinTenant = joinOrgs.join("tenant", JoinType.LEFT);
                predicates.add(builder.like((Expression)joinTenant.get("tenantName"), query.getTenantName() + "%"));
                if (query.getStatus() != null && query.getStatus() == 1) {
                    predicates.add(builder.equal((Expression)joinTenant.get("status"), (Object)1));
                }
            }
            if (query.getStatus() != null && query.getStatus() == 1) {
                predicates.add(builder.equal((Expression)joinOrgs.get("status"), (Object)1));
            }
            joinTable = true;
        }
        if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode())) {
            companyCodes = Arrays.stream(StringUtils.split((String)query.getCompanyCode(), (String)",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            if (companyCodes != null && !companyCodes.isEmpty()) {
                if (companyCodes.size() == 1) {
                    predicates.add(builder.equal((Expression)root.get("companyCode"), companyCodes.stream().findFirst().get()));
                } else {
                    predicates.add(root.get("companyCode").in(companyCodes));
                }
            }
        } else if (ArrayUtils.isNotEmpty((Object[])query.getCompanyCodes())) {
            companyCodes = Arrays.stream(query.getCompanyCodes()).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            if (companyCodes.size() == 1) {
                predicates.add(builder.equal((Expression)root.get("companyCode"), companyCodes.stream().findFirst().get()));
            } else {
                predicates.add(root.get("companyCode").in(companyCodes));
            }
        }
        if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
            predicates.add(builder.equal((Expression)root.get("companyId"), (Object)query.getCompanyId()));
        } else if (ArrayUtils.isNotEmpty((Object[])query.getCompanyIds())) {
            if (query.getCompanyIds().length == 1) {
                predicates.add(builder.equal((Expression)root.get("companyId"), (Object)Arrays.stream(query.getCompanyIds()).findFirst().get()));
            } else {
                predicates.add(root.get("companyId").in((Collection)Arrays.stream(query.getCompanyIds()).collect(Collectors.toSet())));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)query.getTaxNum()) && (taxNums = Arrays.stream(StringUtils.split((String)query.getTaxNum(), (String)",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet())) != null && !taxNums.isEmpty()) {
            if (taxNums.size() == 1) {
                predicates.add(builder.equal((Expression)root.get("taxNum"), taxNums.stream().findFirst().get()));
            } else {
                predicates.add(root.get("taxNum").in(taxNums));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
            predicates.add(builder.like((Expression)root.get("companyName"), query.getCompanyName() + "%"));
        }
        if (query.getInspectionServiceFlag() != null && query.getInspectionServiceFlag() > 0) {
            predicates.add(builder.equal((Expression)root.get("inspectionServiceFlag"), (Object)query.getInspectionServiceFlag()));
        }
        if (query.getSpeedInspectionChannelFlag() != null && query.getSpeedInspectionChannelFlag() > 0) {
            predicates.add(builder.equal((Expression)root.get("speedInspectionChannelFlag"), (Object)query.getSpeedInspectionChannelFlag()));
        }
        if (query.getTraditionAuthenFlag() != null && query.getTraditionAuthenFlag() > 0) {
            predicates.add(builder.equal((Expression)root.get("traditionAuthenFlag"), (Object)query.getTraditionAuthenFlag()));
        }
        if (query.getStatus() != null) {
            predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
        }
        if (!predicates.isEmpty()) {
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
        }
        if (joinTable) {
            criteriaQuery = isCount ? criteriaQuery.distinct(true) : criteriaQuery.groupBy(new Expression[]{root.get("companyId")});
            predicate = criteriaQuery.getGroupRestriction();
        } else {
            predicate = criteriaQuery.getRestriction();
        }
        return predicate;
    }

    public static Specification<Company> queryOneSpecification(CompanyModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getTenantId() != null && query.getTenantId() > 0L || StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                ListJoin joinOrgs = root.joinList("orgs", JoinType.LEFT);
                if (query.getTenantId() != null && query.getTenantId() > 0L) {
                    predicates.add(builder.equal((Expression)joinOrgs.get("tenantId"), (Object)query.getTenantId()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                    Join joinTenant = joinOrgs.join("tenant", JoinType.LEFT);
                    predicates.add(builder.equal((Expression)joinTenant.get("tenantName"), (Object)query.getTenantName()));
                }
                criteriaQuery.groupBy(new Expression[]{root.get("companyId")});
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("companyId"), (Object)query.getCompanyId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode()) || StringUtils.isNotBlank((CharSequence)query.getTaxNum()) || StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                Predicate predicate = builder.disjunction();
                if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get("companyCode"), (Object)query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get("taxNum"), (Object)query.getTaxNum()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get("companyName"), (Object)query.getCompanyName()));
                }
                if (predicate != null) {
                    predicates.add(predicate);
                }
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("\u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

