/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.CompanyTenantRelOperationModel;
import com.xforceplus.domain.company.Switch;
import com.xforceplus.entity.CompanyTenantRelOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class CompanyTenantRelOperationQueryHelper {
    public static final String ID = "id";
    public static final String TAX_NUM = "taxNum";
    public static final String COMPANY_NAME = "companyName";
    public static final String COMPANY_CODE = "companyCode";
    public static final String TENANT_ID = "tenantId";
    public static final String TENANT_CODE = "tenantCode";
    public static final String TENANT_NAME = "tenantName";
    public static final String COMPANY_ID = "companyId";
    public static final String OPERATION_TYPE = "operationType";
    public static final String STATUS = "status";
    public static final String SWITCHES = "switches";
    public static final String RELATED_TENANT_ID = "relatedTenantId";
    public static final String RELATED_TENANT_NAME = "relatedTenantName";
    public static final String CREATER_TENANT_ID = "createrTenantId";
    public static final String INVITING_COMPANY_ID = "invitingCompanyId";
    public static final String INVITING_COMPANY_NAME = "invitingCompanyName";

    public static Specification<CompanyTenantRelOperation> querySpecification(CompanyTenantRelOperationModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> CompanyTenantRelOperationQueryHelper.toPredicate(query, (Root<CompanyTenantRelOperation>)root, criteriaQuery, builder);
        return specification;
    }

    public static Predicate queryTuplePredicate(CompanyTenantRelOperationModel.Request.Query query, Root<CompanyTenantRelOperation> root, CriteriaQuery<Tuple> criteriaQuery, CriteriaBuilder builder) {
        return CompanyTenantRelOperationQueryHelper.toPredicate(query, root, criteriaQuery, builder);
    }

    public static Predicate queryCountPredicate(CompanyTenantRelOperationModel.Request.Query query, Root<CompanyTenantRelOperation> root, CriteriaQuery<Long> criteriaQuery, CriteriaBuilder builder) {
        return CompanyTenantRelOperationQueryHelper.toPredicate(query, root, criteriaQuery, builder);
    }

    private static <T> Predicate toPredicate(CompanyTenantRelOperationModel.Request.Query query, Root<CompanyTenantRelOperation> root, CriteriaQuery<T> criteriaQuery, CriteriaBuilder builder) {
        String[] switches;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Class resultType = criteriaQuery.getResultType();
        if (query.isTuple() && resultType.isAssignableFrom(Tuple.class)) {
            Join joinCompany = root.join("company", JoinType.LEFT);
            Join joinTenant = joinCompany.join("hostTenant", JoinType.LEFT);
            List selections = Stream.of(root.alias("operation")).collect(Collectors.toList());
            if (query.isHasHostTenantId()) {
                selections.add(joinTenant.get(TENANT_ID).alias("hostTenantId"));
            }
            if (query.isHasHostTenantCode()) {
                selections.add(joinTenant.get(TENANT_CODE).alias("hostTenantCode"));
            }
            if (query.isHasHostTenantName()) {
                selections.add(joinTenant.get(TENANT_NAME).alias("hostTenantName"));
            }
            criteriaQuery = criteriaQuery.multiselect(selections);
        }
        if (query.getId() != null && query.getId() > 0L) {
            predicates.add(builder.equal((Expression)root.get(ID), (Object)query.getId()));
        }
        if (query.getTenantId() != null && query.getTenantId() > 0L) {
            predicates.add(builder.equal((Expression)root.get(TENANT_ID), (Object)query.getTenantId()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
            predicates.add(builder.like((Expression)root.get(TENANT_NAME), query.getTenantName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
            predicates.add(builder.like((Expression)root.get(TENANT_CODE), query.getTenantCode() + "%"));
        }
        if (query.getInvitingCompanyId() != null && query.getInvitingCompanyId() > 0L) {
            predicates.add(builder.equal((Expression)root.get(INVITING_COMPANY_ID), (Object)query.getInvitingCompanyId()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getInvitingCompanyName())) {
            predicates.add(builder.like((Expression)root.get(INVITING_COMPANY_NAME), query.getInvitingCompanyName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode())) {
            predicates.add(builder.like((Expression)root.get(COMPANY_CODE), query.getCompanyCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
            predicates.add(builder.like((Expression)root.get(TAX_NUM), query.getTaxNum() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
            predicates.add(builder.like((Expression)root.get(COMPANY_NAME), query.getCompanyName() + "%"));
        }
        if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
            predicates.add(builder.equal((Expression)root.get(COMPANY_ID), (Object)query.getCompanyId()));
        }
        if (query.getCreaterTenantId() != null && query.getCreaterTenantId() > 0L) {
            predicates.add(builder.equal((Expression)root.get(CREATER_TENANT_ID), (Object)query.getCreaterTenantId()));
        }
        if (query.getRelatedTenantId() != null && query.getRelatedTenantId() > 0L) {
            predicates.add(builder.equal((Expression)root.get(RELATED_TENANT_ID), (Object)query.getRelatedTenantId()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getRelatedTenantName())) {
            predicates.add(builder.like((Expression)root.get(RELATED_TENANT_NAME), query.getRelatedTenantName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getAllSwitches())) {
            switches = StringUtils.split((String)query.getAllSwitches(), (String)",");
            int allSwitches = Switch.toValue((String)query.getAllSwitches());
            predicates.add(builder.equal(builder.function("bitwiseAnd", Integer.class, new Expression[]{root.get(SWITCHES), builder.literal((Object)allSwitches)}), (Object)allSwitches));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getAnySwitches())) {
            switches = StringUtils.split((String)query.getAnySwitches(), (String)",");
            int anySwitches = Switch.toValue((String)query.getAnySwitches());
            predicates.add(builder.gt(builder.function("bitwiseAnd", Integer.class, new Expression[]{root.get(SWITCHES), builder.literal((Object)anySwitches)}), (Number)0));
        }
        if (query.getOperationType() != null) {
            predicates.add(builder.equal((Expression)root.get(OPERATION_TYPE), (Object)query.getOperationType()));
        }
        if ((query.getOperationType() == null || query.getOperationType() == 0) && query.getStatus() != null) {
            predicates.add(builder.equal((Expression)root.get(STATUS), (Object)query.getStatus()));
        }
        if (query.getWithoutStatus() != null && query.getWithoutStatus() > 0) {
            predicates.add(builder.notEqual((Expression)root.get(STATUS), (Object)query.getWithoutStatus()));
        }
        if (!predicates.isEmpty()) {
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
        }
        return criteriaQuery.getRestriction();
    }

    public static Specification<CompanyTenantRelOperation> queryOneSpecification(CompanyTenantRelOperationModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            String[] switches;
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(TENANT_ID), (Object)query.getTenantId()));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(COMPANY_ID), (Object)query.getCompanyId()));
            }
            if (query.getCreaterTenantId() != null && query.getCreaterTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(CREATER_TENANT_ID), (Object)query.getCreaterTenantId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode()) || StringUtils.isNotBlank((CharSequence)query.getTaxNum()) || StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                Predicate predicate = builder.disjunction();
                if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get(COMPANY_CODE), (Object)query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get(TAX_NUM), (Object)query.getTaxNum()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get(COMPANY_NAME), (Object)query.getCompanyName()));
                }
                if (predicate != null) {
                    predicates.add(predicate);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)query.getAllSwitches())) {
                switches = StringUtils.split((String)query.getAllSwitches(), (String)",");
                int allSwitches = Switch.toValue((String)query.getAllSwitches());
                predicates.add(builder.equal(builder.function("bitwiseAnd", Integer.class, new Expression[]{root.get(SWITCHES), builder.literal((Object)allSwitches)}), (Object)allSwitches));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getAnySwitches())) {
                switches = StringUtils.split((String)query.getAnySwitches(), (String)",");
                int anySwitches = Switch.toValue((String)query.getAnySwitches());
                predicates.add(builder.gt(builder.function("bitwiseAnd", Integer.class, new Expression[]{root.get(SWITCHES), builder.literal((Object)anySwitches)}), (Number)0));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get(STATUS), (Object)query.getStatus()));
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("\u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

