/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.CompanyTenantRelModel;
import com.xforceplus.domain.company.Switch;
import com.xforceplus.entity.CompanyTenantRel;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class CompanyTenantRelQueryHelper {
    public static final String COMPANY_ID = "companyId";
    public static final String TAX_NUM = "taxNum";
    public static final String COMPANY_NAME = "companyName";
    public static final String COMPANY_CODE = "companyCode";
    public static final String TENANT_ID = "tenantId";
    public static final String TENANT_CODE = "tenantCode";
    public static final String TENANT_NAME = "tenantName";
    public static final String HOST_TENANT_ID = "hostTenantId";
    public static final String RELATED_TENANT_ID = "relatedTenantId";
    public static final String RELATED_TENANT_NAME = "relatedTenantName";
    public static final String RELATED_TENANT_CODE = "relatedTenantCode";
    public static final String COMPANY = "company";
    public static final String HOST_TENANT = "hostTenant";
    public static final String TENANT = "tenant";
    public static final String RELATED_TENANT = "relatedTenant";
    public static final String RELATED_COMPANY = "relatedCompany";
    public static final String STATUS = "status";
    public static final String SWITCHES = "switches";

    public static Specification<CompanyTenantRel> querySpecification(CompanyTenantRelModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            String[] switches;
            Join joinTenant;
            Join joinCompany;
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(TENANT_ID), (Object)query.getTenantId()));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(COMPANY_ID), (Object)query.getCompanyId()));
            }
            if (query.getRelatedTenantId() != null && query.getRelatedTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(RELATED_TENANT_ID), (Object)query.getRelatedTenantId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode()) || StringUtils.isNotBlank((CharSequence)query.getTaxNum()) || StringUtils.isNotBlank((CharSequence)query.getCompanyName()) || query.getTenantId() != null && query.getTenantId() > 0L || StringUtils.isNotBlank((CharSequence)query.getHostTenantCode()) || StringUtils.isNotBlank((CharSequence)query.getHostTenantName())) {
                joinCompany = root.join(COMPANY, JoinType.LEFT);
                if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode())) {
                    predicates.add(builder.equal((Expression)joinCompany.get(COMPANY_CODE), (Object)query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                    predicates.add(builder.equal((Expression)joinCompany.get(TAX_NUM), (Object)query.getTaxNum()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                    predicates.add(builder.like((Expression)joinCompany.get(COMPANY_NAME), query.getCompanyName()));
                }
                if (query.getHostTenantId() != null && query.getHostTenantId() > 0L) {
                    predicates.add(builder.equal((Expression)joinCompany.get(HOST_TENANT_ID), (Object)query.getHostTenantId()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getHostTenantCode()) || StringUtils.isNotBlank((CharSequence)query.getHostTenantName())) {
                    Join joinTenant2 = joinCompany.join(HOST_TENANT, JoinType.LEFT);
                    if (StringUtils.isNotBlank((CharSequence)query.getHostTenantCode())) {
                        predicates.add(builder.equal((Expression)joinTenant2.get(TENANT_CODE), (Object)query.getHostTenantCode()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)query.getHostTenantName())) {
                        predicates.add(builder.like((Expression)joinTenant2.get(TENANT_NAME), query.getHostTenantName()));
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantCode()) || StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                joinTenant = root.join(TENANT, JoinType.LEFT);
                if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                    predicates.add(builder.equal((Expression)joinTenant.get(TENANT_CODE), (Object)query.getTenantCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                    predicates.add(builder.equal((Expression)joinTenant.get(TENANT_NAME), (Object)query.getTenantName()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)query.getRelatedTenantCode()) || StringUtils.isNotBlank((CharSequence)query.getRelatedTenantName())) {
                joinTenant = root.join(RELATED_TENANT, JoinType.LEFT);
                if (StringUtils.isNotBlank((CharSequence)query.getRelatedTenantCode())) {
                    predicates.add(builder.equal((Expression)joinTenant.get(TENANT_CODE), (Object)query.getRelatedTenantCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getRelatedTenantName())) {
                    predicates.add(builder.equal((Expression)joinTenant.get(TENANT_NAME), (Object)query.getRelatedTenantName()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)query.getRelatedCompanyCode()) || StringUtils.isNotBlank((CharSequence)query.getRelatedCompanyName())) {
                joinCompany = root.join(RELATED_COMPANY, JoinType.LEFT);
                if (StringUtils.isNotBlank((CharSequence)query.getRelatedCompanyCode())) {
                    predicates.add(builder.equal((Expression)joinCompany.get(COMPANY_CODE), (Object)query.getRelatedCompanyCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getRelatedCompanyName())) {
                    predicates.add(builder.equal((Expression)joinCompany.get(COMPANY_NAME), (Object)query.getRelatedCompanyName()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)query.getAllSwitches())) {
                switches = StringUtils.split((String)query.getAllSwitches(), (String)",");
                int allSwitches = Switch.toValue((String)query.getAllSwitches());
                predicates.add(builder.equal(builder.function("bitwiseAnd", Integer.class, new Expression[]{root.get(SWITCHES), builder.literal((Object)allSwitches)}), (Object)allSwitches));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getAnySwitches())) {
                switches = StringUtils.split((String)query.getAnySwitches(), (String)",");
                int anySwitches = Switch.toValue((String)query.getAnySwitches());
                predicates.add(builder.gt(builder.function("bitwiseAnd", Integer.class, new Expression[]{root.get(SWITCHES), builder.literal((Object)anySwitches)}), (Number)0));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<CompanyTenantRel> queryOneSpecification(CompanyTenantRelModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            String[] switches;
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(TENANT_ID), (Object)query.getTenantId()));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(COMPANY_ID), (Object)query.getCompanyId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode()) || StringUtils.isNotBlank((CharSequence)query.getTaxNum()) || StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                Predicate predicate = builder.disjunction();
                if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get(COMPANY_CODE), (Object)query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get(TAX_NUM), (Object)query.getTaxNum()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get(COMPANY_NAME), (Object)query.getCompanyName()));
                }
                if (predicate != null) {
                    predicates.add(predicate);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)query.getAllSwitches())) {
                switches = StringUtils.split((String)query.getAllSwitches(), (String)",");
                int allSwitches = Switch.toValue((String)query.getAllSwitches());
                predicates.add(builder.equal(builder.function("bitwiseAnd", Integer.class, new Expression[]{root.get(SWITCHES), builder.literal((Object)allSwitches)}), (Object)allSwitches));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getAnySwitches())) {
                switches = StringUtils.split((String)query.getAnySwitches(), (String)",");
                int anySwitches = Switch.toValue((String)query.getAnySwitches());
                predicates.add(builder.gt(builder.function("bitwiseAnd", Integer.class, new Expression[]{root.get(SWITCHES), builder.literal((Object)anySwitches)}), (Number)0));
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("\u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

