/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.OrgExtensionModel;
import com.xforceplus.entity.OrgExtension;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class OrgExtensionQueryHelper {
    public static Specification<OrgExtension> querySpecification(OrgExtensionModel.Request.Query query) {
        return (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getOrgStructId() != null && query.getOrgStructId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("orgStructId"), (Object)query.getOrgStructId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getOrgName()) || StringUtils.isNotBlank((CharSequence)query.getTenantName()) || StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                Join joinOrg = root.join("org", JoinType.LEFT);
                if (StringUtils.isNotBlank((CharSequence)query.getOrgName())) {
                    predicates.add(builder.like((Expression)joinOrg.get("orgName"), "%" + query.getOrgName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getTenantName()) || StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                    Join joinTenant = joinOrg.join("tenant", JoinType.LEFT);
                    if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                        predicates.add(builder.like((Expression)joinTenant.get("tenantName"), "%" + query.getTenantName() + "%"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                        predicates.add(builder.like((Expression)joinTenant.get("tenantCode"), "%" + query.getTenantCode() + "%"));
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)query.getExtensionKey())) {
                predicates.add(builder.equal((Expression)root.get("extensionKey"), (Object)query.getExtensionKey()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getExtensionValue())) {
                predicates.add(builder.equal((Expression)root.get("extensionValue"), (Object)query.getExtensionValue()));
            }
            if (query.getStatus() == null) {
                query.setStatus(Integer.valueOf(1));
            }
            predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
    }
}

