/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.OrgModel;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import com.xforceplus.tenant.security.core.domain.OrgType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.SetJoin;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.CollectionUtils;

public class OrgQueryHelper {
    public static Specification<OrgStruct> querySpecification(OrgModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> OrgQueryHelper.toPredicate(query, (Root<OrgStruct>)root, criteriaQuery, builder);
        return specification;
    }

    public static Predicate queryTuplePredicate(OrgModel.Request.Query query, Root<OrgStruct> root, CriteriaQuery<Tuple> criteriaQuery, CriteriaBuilder builder) {
        return OrgQueryHelper.toPredicate(query, root, criteriaQuery, builder);
    }

    public static Predicate queryCountPredicate(OrgModel.Request.Query query, Root<OrgStruct> root, CriteriaQuery<Long> criteriaQuery, CriteriaBuilder builder) {
        return OrgQueryHelper.toPredicate(query, root, criteriaQuery, builder);
    }

    private static <T> Predicate toPredicate(OrgModel.Request.Query query, Root<OrgStruct> root, CriteriaQuery<T> criteriaQuery, CriteriaBuilder builder) {
        List predicateList;
        Object[] orgNameLikes;
        Set orgCodesQuery;
        Set orgIdsQuery;
        ArrayList<Object> predicates = new ArrayList<Object>();
        Class resultType = criteriaQuery.getResultType();
        boolean isCount = resultType.isAssignableFrom(Long.class);
        boolean joinTable = false;
        Join joinCompany = null;
        Join joinTenant = null;
        List selections = null;
        if (resultType.isAssignableFrom(Tuple.class)) {
            joinCompany = root.join("company", JoinType.LEFT);
            joinTenant = root.join("tenant", JoinType.LEFT);
            selections = Stream.of(root.alias("org"), joinCompany.alias("company"), joinTenant.alias("tenant")).collect(Collectors.toList());
        }
        if (query.getUserId() != null && query.getUserId() > 0L || query.getAccountId() != null && query.getAccountId() > 0L) {
            ListJoin joinOrgUserRel = root.joinList("orgUserRels", JoinType.LEFT);
            joinTable = true;
            if (query.getUserId() != null && query.getUserId() > 0L) {
                boolean filterUserId = true;
                boolean joinUserWithOnCondition = false;
                if (selections != null && (query.getUserBoundFront() != null && query.getUserBoundFront().booleanValue() || query.getWithUserBoundFlag() != null && query.getWithUserBoundFlag().booleanValue())) {
                    joinOrgUserRel.on((Expression)builder.equal((Expression)joinOrgUserRel.get("userId"), (Object)query.getUserId()));
                    joinUserWithOnCondition = true;
                    Expression countExpression = builder.count((Expression)joinOrgUserRel.get("id"));
                    if (query.getWithUserBoundFlag() != null && query.getWithUserBoundFlag().booleanValue()) {
                        selections.add(countExpression.alias("userBound"));
                    }
                    if (query.getUserBoundFront() != null && query.getUserBoundFront().booleanValue()) {
                        criteriaQuery.orderBy(new Order[]{builder.desc(countExpression)});
                    }
                    filterUserId = false;
                }
                if (query.getUserUnBound() != null && query.getUserUnBound().booleanValue()) {
                    if (!joinUserWithOnCondition) {
                        joinOrgUserRel.on((Expression)builder.equal((Expression)joinOrgUserRel.get("userId"), (Object)query.getUserId()));
                        joinUserWithOnCondition = true;
                    }
                    filterUserId = false;
                    predicates.add(builder.isNull((Expression)joinOrgUserRel.get("id")));
                }
                if (filterUserId) {
                    predicates.add(builder.equal((Expression)joinOrgUserRel.get("userId"), (Object)query.getUserId()));
                }
            }
            if (query.getAccountId() != null && query.getAccountId() > 0L) {
                Join joinUser = joinOrgUserRel.join("user", JoinType.LEFT);
                predicates.add(builder.equal((Expression)joinUser.get("accountId"), (Object)query.getAccountId()));
                if (query.getStatus() != null && query.getStatus() == 1) {
                    predicates.add(builder.equal((Expression)joinUser.get("status"), (Object)1));
                }
            }
        }
        if (selections != null) {
            if (query.getWithIsHost() != null && query.getWithIsHost().booleanValue()) {
                selections.add(builder.selectCase().when((Expression)builder.equal((Expression)joinCompany.get("hostTenantId"), (Expression)root.get("tenantId")), (Object)Boolean.TRUE).otherwise((Object)Boolean.FALSE).alias("thisIsHost"));
            }
            criteriaQuery = criteriaQuery.multiselect(selections);
        }
        if (StringUtils.isNotBlank((CharSequence)query.getCompanyNo())) {
            SetJoin joinCompanyNo = root.joinSet("companyNos", JoinType.LEFT);
            Set companyNos = Arrays.stream(StringUtils.split((String)query.getCompanyNo(), (String)",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            if (!companyNos.isEmpty()) {
                if (companyNos.size() == 1) {
                    predicates.add(builder.equal((Expression)joinCompanyNo, companyNos.stream().findFirst().get()));
                } else {
                    predicates.add(joinCompanyNo.in(companyNos));
                }
            } else {
                predicates.add(builder.equal((Expression)joinCompanyNo, (Object)query.getCompanyNo()));
            }
            joinTable = true;
        }
        if ((orgIdsQuery = query.getOrgId() != null && query.getOrgId() > 0L ? Stream.of(query.getOrgId()).collect(Collectors.toSet()) : (query.getOrgIds() != null && !query.getOrgIds().isEmpty() ? new HashSet(query.getOrgIds()) : null)) != null && !orgIdsQuery.isEmpty()) {
            if (orgIdsQuery.size() == 1) {
                predicates.add(builder.equal((Expression)root.get("orgId"), orgIdsQuery.stream().findFirst().get()));
            } else {
                predicates.add(root.get("orgId").in(orgIdsQuery));
            }
        }
        if (query.getTenantId() != null && query.getTenantId() > 0L) {
            predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
            if (!CollectionUtils.isEmpty((Collection)query.getFilterParentIds())) {
                HashSet<String> filterParentIdsSet = new HashSet<String>();
                ArrayList<Predicate> predicateList2 = new ArrayList<Predicate>();
                ArrayList filterParentIdsList = new ArrayList(query.getFilterParentIds());
                Collections.sort(filterParentIdsList);
                for (String filterParentIds : filterParentIdsList) {
                    if (!filterParentIdsSet.stream().noneMatch(parentIds -> StringUtils.startsWith((CharSequence)filterParentIds, (CharSequence)parentIds))) continue;
                    filterParentIdsSet.add(filterParentIds);
                    predicateList2.add(builder.like((Expression)root.get("parentIds"), StringUtils.appendIfMissing((String)filterParentIds, (CharSequence)"%", (CharSequence[])new CharSequence[0])));
                }
                if (!predicateList2.isEmpty()) {
                    if (predicateList2.size() == 1) {
                        predicates.add(predicateList2.stream().findFirst().get());
                    } else {
                        predicates.add(builder.or((Predicate[])predicateList2.stream().toArray(Predicate[]::new)));
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)query.getTenantCode()) || StringUtils.isNotBlank((CharSequence)query.getTenantName()) || StringUtils.isNotBlank((CharSequence)query.getTenantNameEqual())) {
            if (joinTenant == null) {
                joinTenant = root.join("tenant", JoinType.LEFT);
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                predicates.add(builder.equal((Expression)joinTenant.get("tenantCode"), (Object)query.getTenantCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantNameEqual())) {
                predicates.add(builder.equal((Expression)joinTenant.get("tenantName"), (Object)query.getTenantNameEqual()));
            } else if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                String tenantName = StringUtils.appendIfMissing((String)query.getTenantName(), (CharSequence)"%", (CharSequence[])new CharSequence[0]);
                predicates.add(builder.like((Expression)joinTenant.get("tenantName"), tenantName));
            }
        }
        if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
            predicates.add(builder.equal((Expression)root.get("companyId"), (Object)query.getCompanyId()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getOrgCode()) && !CollectionUtils.isEmpty(orgCodesQuery = Arrays.stream(StringUtils.split((String)query.getOrgCode(), (String)",")).collect(Collectors.toSet()))) {
            if (orgCodesQuery.size() == 1) {
                predicates.add(builder.equal((Expression)root.get("orgCode"), orgCodesQuery.stream().findFirst().get()));
            } else {
                predicates.add(root.get("orgCode").in(orgCodesQuery));
            }
        }
        if (query.getOrgType() != null) {
            OrgType orgType;
            try {
                int orgTypeVal = Integer.parseInt(query.getOrgType());
                orgType = OrgType.values()[orgTypeVal];
            }
            catch (Exception e) {
                try {
                    orgType = OrgType.valueOf((String)query.getOrgType());
                }
                catch (Exception e1) {
                    orgType = null;
                }
            }
            if (orgType != null) {
                predicates.add(builder.equal((Expression)root.get("orgType"), (Object)orgType));
            }
        }
        if (query.getWithNoRootOrg() != null && query.getWithNoRootOrg().equals(Boolean.TRUE)) {
            predicates.add(builder.notEqual((Expression)root.get("orgType"), (Object)OrgType.GROUP));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getOrgNameEqual())) {
            predicates.add(builder.equal((Expression)root.get("orgName"), (Object)query.getOrgNameEqual()));
        } else if (StringUtils.isNotBlank((CharSequence)query.getOrgName())) {
            Set orgNames = Arrays.stream(StringUtils.split((String)query.getOrgName(), (String)",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            if (!orgNames.isEmpty()) {
                if (orgNames.size() == 1) {
                    String orgName2 = StringUtils.appendIfMissing((String)query.getOrgName(), (CharSequence)"%", (CharSequence[])new CharSequence[0]);
                    predicates.add(builder.like((Expression)root.get("orgName"), orgName2));
                } else {
                    predicates.add(root.get("orgName").in(orgNames));
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)query.getOrgNameLike()) && ArrayUtils.isNotEmpty((Object[])(orgNameLikes = StringUtils.split((String)query.getOrgNameLike(), (String)","))) && !(predicateList = Arrays.stream(orgNameLikes).map(orgName -> StringUtils.appendIfMissing((String)orgName, (CharSequence)"%", (CharSequence[])new CharSequence[0])).map(orgName -> StringUtils.prependIfMissing((String)orgName, (CharSequence)"%", (CharSequence[])new CharSequence[0])).map(orgName -> builder.like((Expression)root.get("orgName"), orgName)).collect(Collectors.toList())).isEmpty()) {
            if (predicateList.size() == 1) {
                predicates.add(predicateList.stream().findFirst().get());
            } else {
                predicates.add(builder.or((Predicate[])predicateList.stream().toArray(Predicate[]::new)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)query.getOrgBizType())) {
            String orgBizType = StringUtils.appendIfMissing((String)query.getOrgBizType(), (CharSequence)"%", (CharSequence[])new CharSequence[0]);
            predicates.add(builder.like((Expression)root.get("orgBizType"), orgBizType));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getParentIds())) {
            String parentIds2 = StringUtils.appendIfMissing((String)query.getParentIds(), (CharSequence)"%", (CharSequence[])new CharSequence[0]);
            predicates.add(builder.like((Expression)root.get("parentIds"), parentIds2));
        }
        if (query.getStatus() != null) {
            predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
        }
        if (query.getGradingRoleId() != null) {
            predicates.add(builder.equal((Expression)root.get("gradingRoleId"), (Object)query.getGradingRoleId()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode()) || StringUtils.isNotBlank((CharSequence)query.getCompanyName()) || StringUtils.isNotBlank((CharSequence)query.getCompanyNameEqual()) || StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
            Set taxNums;
            Set companyCodes;
            if (joinCompany == null) {
                joinCompany = root.join("company", JoinType.LEFT);
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode()) && (companyCodes = Arrays.stream(StringUtils.split((String)query.getCompanyCode(), (String)",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet())) != null && !companyCodes.isEmpty()) {
                if (companyCodes.size() == 1) {
                    predicates.add(builder.equal((Expression)joinCompany.get("companyCode"), companyCodes.stream().findFirst().get()));
                } else {
                    predicates.add(joinCompany.get("companyCode").in(companyCodes));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyNameEqual())) {
                predicates.add(builder.equal((Expression)joinCompany.get("companyName"), (Object)query.getCompanyNameEqual()));
            } else if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                String companyName = StringUtils.appendIfMissing((String)query.getCompanyName(), (CharSequence)"%", (CharSequence[])new CharSequence[0]);
                predicates.add(builder.like((Expression)joinCompany.get("companyName"), companyName));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTaxNum()) && (taxNums = Arrays.stream(StringUtils.split((String)query.getTaxNum(), (String)",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet())) != null && !taxNums.isEmpty()) {
                if (taxNums.size() == 1) {
                    predicates.add(builder.equal((Expression)joinCompany.get("taxNum"), taxNums.stream().findFirst().get()));
                } else {
                    predicates.add(joinCompany.get("taxNum").in(taxNums));
                }
            }
            if (query.getStatus() != null && query.getStatus() == 1) {
                predicates.add(builder.equal((Expression)joinCompany.get("status"), (Object)1));
            }
        }
        if (query.getRootOrg() != null && query.getRootOrg().booleanValue()) {
            predicates.add(builder.or((Expression)builder.isNull((Expression)root.get("parentId")), (Expression)builder.equal((Expression)root.get("parentId"), (Object)0)));
        } else if (query.getParentId() != null && query.getParentId() > 0L) {
            predicates.add(builder.equal((Expression)root.get("parentId"), (Object)query.getParentId()));
        }
        if (!CollectionUtils.isEmpty((Collection)query.getIds())) {
            if (query.getIds().size() == 1) {
                predicates.add(builder.equal((Expression)root.get("orgId"), query.getIds().stream().findFirst().get()));
            } else {
                predicates.add(root.get("orgId").in((Collection)query.getIds()));
            }
        }
        if (predicates.isEmpty()) {
            predicates.add(builder.equal((Expression)root.get("status"), (Object)1));
        }
        criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
        if (joinTable) {
            if (isCount) {
                criteriaQuery.distinct(true);
            } else {
                criteriaQuery.groupBy(new Expression[]{root.get("orgId")});
            }
        }
        Predicate predicate = criteriaQuery.getRestriction();
        return predicate;
    }

    public static Function<Tuple, OrgStruct> tupleMapper(final OrgModel.Request.Query query) {
        return new Function<Tuple, OrgStruct>(){

            @Override
            public OrgStruct apply(Tuple tuple) {
                OrgStruct org = (OrgStruct)tuple.get("org", OrgStruct.class);
                if (org != null) {
                    Tenant tenant;
                    Company company = (Company)tuple.get("company", Company.class);
                    if (company != null) {
                        org.setCompany(company);
                    }
                    if ((tenant = (Tenant)tuple.get("tenant", Tenant.class)) != null) {
                        org.setTenant(tenant);
                    }
                    if (query.getWithIsHost() != null && query.getWithIsHost().booleanValue()) {
                        Boolean thisIsHost = (Boolean)tuple.get("thisIsHost", Boolean.class);
                        if (thisIsHost != null) {
                            org.setThisIsHost(thisIsHost);
                        } else {
                            org.setThisIsHost(false);
                        }
                    }
                    if (query.getUserId() != null && query.getUserId() > 0L && query.getWithUserBoundFlag() != null && query.getWithUserBoundFlag().booleanValue()) {
                        Long userBoundCount = (Long)tuple.get("userBound", Long.class);
                        if (userBoundCount != null && userBoundCount > 0L) {
                            org.setUserBound(true);
                        } else {
                            org.setUserBound(false);
                        }
                    }
                }
                return org;
            }
        };
    }

    public static Specification<OrgStruct> queryOneSpecification(OrgModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getOrgId() != null && query.getOrgId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("orgId"), (Object)query.getOrgId()));
            }
            if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
                if (StringUtils.isNotBlank((CharSequence)query.getOrgCode()) || StringUtils.isNotBlank((CharSequence)query.getOrgName()) || query.getCompanyId() != null && query.getCompanyId() > 0L) {
                    if (StringUtils.isNotBlank((CharSequence)query.getOrgCode())) {
                        predicates.add(builder.equal((Expression)root.get("orgCode"), (Object)query.getOrgCode()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)query.getOrgName())) {
                        predicates.add(builder.equal((Expression)root.get("orgName"), (Object)query.getOrgName()));
                    }
                    if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                        predicates.add(builder.equal((Expression)root.get("companyId"), (Object)query.getCompanyId()));
                    }
                }
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("\u7f3a\u5c11\u67e5\u8be2\u53c2\u6570");
            }
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

