/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.entity.OrgVirtual;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class OrgVirtualQueryHelper {
    public static Specification<OrgVirtual> querySpecification(OrgVirtualModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
            if (null != query.getTypeId()) {
                ListJoin joinTreeRels = root.joinList("orgVirtualNodes", JoinType.LEFT);
                predicates.add(builder.equal((Expression)joinTreeRels.get("nodeTypeId"), (Object)query.getTypeId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getOrgName())) {
                predicates.add(builder.like((Expression)root.get("orgName"), query.getOrgName() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getOrgCode())) {
                predicates.add(builder.like((Expression)root.get("orgCode"), query.getOrgCode() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getShortName())) {
                predicates.add(builder.like((Expression)root.get("shortName"), query.getShortName() + "%"));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

