/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.ResourcesetModel;
import com.xforceplus.entity.Resourceset;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class ResourcesetQueryHelper {
    public static Specification<Resourceset> querySpecification(ResourcesetModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            boolean joinTable = false;
            if (query.getTenantId() != null && query.getTenantId() > 0L || query.getServicePackageId() != null && query.getServicePackageId() > 0L || StringUtils.isNotBlank((CharSequence)query.getServicePackageName())) {
                ListJoin joinServiceResourcesetRels = root.joinList("serviceResourcesetRels", JoinType.LEFT);
                if (query.getServicePackageId() != null && query.getServicePackageId() > 0L) {
                    predicates.add(builder.equal((Expression)joinServiceResourcesetRels.get("servicePackageId"), (Object)query.getServicePackageId()));
                } else if (query.getPackageIds() != null && !query.getPackageIds().isEmpty()) {
                    if (query.getPackageIds().size() == 1) {
                        predicates.add(builder.equal((Expression)joinServiceResourcesetRels.get("servicePackageId"), query.getPackageIds().stream().findFirst().get()));
                    } else {
                        predicates.add(joinServiceResourcesetRels.get("servicePackageId").in(query.getPackageIds()));
                    }
                }
                if (query.getTenantId() != null && query.getTenantId() > 0L) {
                    ListJoin joinCompanyServiceRels = joinServiceResourcesetRels.join("servicePackage", JoinType.LEFT).joinList("companyServiceRels", JoinType.LEFT);
                    predicates.add(builder.equal((Expression)joinCompanyServiceRels.get("tenantId"), (Object)query.getTenantId()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getServicePackageName())) {
                    Join joinServicePackage = joinServiceResourcesetRels.join("servicePackage", JoinType.LEFT);
                    if (StringUtils.isNotBlank((CharSequence)query.getServicePackageName())) {
                        predicates.add(builder.like((Expression)joinServicePackage.get("servicePackageName"), query.getServicePackageName() + "%"));
                    }
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal((Expression)joinServicePackage.get("status"), (Object)1));
                    }
                }
                joinTable = true;
            }
            if (query.getRoleId() != null && query.getRoleId() > 0L || query.getUserId() != null && query.getUserId() > 0L) {
                ListJoin joinRoleResourcesetRels = root.joinList("roleResourcesetRels", JoinType.LEFT);
                if (query.getRoleId() != null && query.getRoleId() > 0L) {
                    predicates.add(builder.equal((Expression)joinRoleResourcesetRels.get("roleId"), (Object)query.getRoleId()));
                }
                if (query.getUserId() != null && query.getUserId() > 0L) {
                    Join joinRole = joinRoleResourcesetRels.join("role", JoinType.LEFT);
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal((Expression)joinRole.get("status"), (Object)1));
                    }
                    ListJoin joinRoleUserRels = joinRole.joinList("roleUserRels", JoinType.LEFT);
                    predicates.add(builder.equal((Expression)joinRoleUserRels.get("userId"), (Object)query.getUserId()));
                }
                joinTable = true;
            }
            if (query.getResourceId() != null && query.getResourceId() > 0L || StringUtils.isNotBlank((CharSequence)query.getResourceCode()) || StringUtils.isNotBlank((CharSequence)query.getResourceName())) {
                ListJoin joinResourcesetResourceRels = root.joinList("resourcesetResourceRels", JoinType.LEFT);
                if (query.getResourceId() != null && query.getResourceId() > 0L) {
                    predicates.add(builder.equal((Expression)joinResourcesetResourceRels.get("resourceId"), (Object)query.getResourceId()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getResourceCode()) || StringUtils.isNotBlank((CharSequence)query.getResourceName())) {
                    Join joinResource = joinResourcesetResourceRels.join("resource", JoinType.LEFT);
                    if (StringUtils.isNotBlank((CharSequence)query.getResourceCode())) {
                        predicates.add(builder.like((Expression)joinResource.get("resourceCode"), query.getResourceCode() + "%"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)query.getResourceName())) {
                        predicates.add(builder.like((Expression)joinResource.get("resourceName"), query.getResourceName() + "%"));
                    }
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal((Expression)joinResource.get("status"), (Object)1));
                    }
                }
                joinTable = true;
            }
            if (query.getResourcesetId() != null && query.getResourcesetId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("resourcesetId"), (Object)query.getResourcesetId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getResourcesetName())) {
                predicates.add(builder.like((Expression)root.get("resourcesetName"), query.getResourcesetName() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getResourcesetNameEqual())) {
                predicates.add(builder.equal((Expression)root.get("resourcesetName"), (Object)query.getResourcesetName()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getResourcesetCode())) {
                predicates.add(builder.like((Expression)root.get("resourcesetCode"), query.getResourcesetCode() + "%"));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
            }
            if (query.getAppId() != null && query.getAppId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("appId"), (Object)query.getAppId()));
            }
            if (null != query.getContainCustomFlag() && !query.getContainCustomFlag().booleanValue()) {
                predicates.add(builder.isNull((Expression)root.get("roleId")));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                }
                criteriaQuery.groupBy(new Expression[]{root.get("resourcesetId")});
                return criteriaQuery.getGroupRestriction();
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<Resourceset> queryOneSpecification(ResourcesetModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getResourcesetId() != null && query.getResourcesetId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("resourcesetId"), (Object)query.getResourcesetId()));
            } else {
                if (StringUtils.isNotBlank((CharSequence)query.getResourcesetCode())) {
                    predicates.add(builder.equal((Expression)root.get("resourcesetCode"), (Object)query.getResourcesetCode()));
                } else {
                    if (StringUtils.isNotBlank((CharSequence)query.getResourcesetName())) {
                        predicates.add(builder.equal((Expression)root.get("resourcesetName"), (Object)query.getResourcesetName()));
                    }
                    if (query.getAppId() != null && query.getAppId() > 0L) {
                        predicates.add(builder.equal((Expression)root.get("appId"), (Object)query.getAppId()));
                    }
                }
                if (null != query.getRoleId()) {
                    predicates.add(builder.equal((Expression)root.get("roleId"), (Object)query.getRoleId()));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

