/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.TenantPolicyModel;
import com.xforceplus.entity.TenantPolicy;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.StringUtils;

public class TenantPolicyQueryHelper {
    public static Specification<TenantPolicy> querySpecification(TenantPolicyModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Join joinTenant = root.join("tenant", JoinType.LEFT);
            if (!StringUtils.isEmpty((Object)query.getTenantCode())) {
                predicates.add(builder.equal((Expression)joinTenant.get("tenantCode"), (Object)query.getTenantCode()));
            }
            if (!StringUtils.isEmpty((Object)query.getTenantNameEqual())) {
                predicates.add(builder.equal((Expression)joinTenant.get("tenantName"), (Object)query.getTenantNameEqual()));
            }
            if (!StringUtils.isEmpty((Object)query.getTenantName())) {
                predicates.add(builder.like((Expression)joinTenant.get("tenantName"), "%" + query.getTenantName() + "%"));
            }
            if (!StringUtils.isEmpty((Object)query.getTenantId())) {
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
            }
            if (!StringUtils.isEmpty((Object)query.getName())) {
                predicates.add(builder.equal((Expression)root.get("name"), (Object)query.getName()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

