/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.TenantModel;
import com.xforceplus.entity.Tenant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class TenantQueryHelper {
    public static Specification<Tenant> querySpecification(TenantModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            Set tenantCodes;
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            boolean joinTable = false;
            if (query.getUserId() != null && query.getUserId() > 0L || query.getAccountId() != null && query.getAccountId() > 0L) {
                ListJoin joinUser = root.joinList("users", JoinType.LEFT);
                if (query.getAccountId() != null && query.getAccountId() > 0L) {
                    predicates.add(builder.equal((Expression)joinUser.get("accountId"), (Object)query.getAccountId()));
                }
                if (query.getUserId() != null && query.getUserId() > 0L) {
                    predicates.add(builder.equal((Expression)joinUser.get("id"), (Object)query.getUserId()));
                }
                if (query.getStatus() != null) {
                    predicates.add(builder.equal((Expression)joinUser.get("status"), (Object)query.getStatus()));
                }
                joinTable = true;
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                ListJoin joinOrg = root.joinList("orgs", JoinType.LEFT);
                predicates.add(builder.equal((Expression)joinOrg.get("companyId"), (Object)query.getCompanyId()));
                if (query.getThisIsHost() != null) {
                    Join joinCompany = joinOrg.join("company", JoinType.LEFT);
                    if (query.getThisIsHost().booleanValue()) {
                        predicates.add(builder.equal((Expression)joinCompany.get("hostTenantId"), (Expression)root.get("tenantId")));
                    } else {
                        predicates.add(builder.notEqual((Expression)joinCompany.get("hostTenantId"), (Expression)root.get("tenantId")));
                    }
                }
                if (query.getStatus() != null) {
                    predicates.add(builder.equal((Expression)joinOrg.get("status"), (Object)query.getStatus()));
                }
                joinTable = true;
            }
            if (null != query.getStartDate()) {
                predicates.add(builder.greaterThanOrEqualTo((Expression)root.get("createTime"), (Comparable)query.getStartDate()));
            }
            if (null != query.getEndDate()) {
                query.getEndDate().setHours(query.getEndDate().getHours() + 24);
                predicates.add(builder.lessThanOrEqualTo((Expression)root.get("createTime"), (Comparable)query.getEndDate()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantCode()) && (tenantCodes = Arrays.stream(StringUtils.split((String)query.getTenantCode(), (String)",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet())) != null && !tenantCodes.isEmpty()) {
                if (tenantCodes.size() == 1) {
                    predicates.add(builder.equal((Expression)root.get("tenantCode"), tenantCodes.stream().findFirst().get()));
                } else {
                    predicates.add(root.get("tenantCode").in(tenantCodes));
                }
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
            }
            if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
            } else if (ArrayUtils.isNotEmpty((Object[])query.getTenantIds())) {
                Set tenantIds = Arrays.stream(query.getTenantIds()).collect(Collectors.toSet());
                if (tenantIds.size() == 1) {
                    predicates.add(builder.equal((Expression)root.get("tenantId"), tenantIds.stream().findFirst().get()));
                } else {
                    predicates.add(root.get("tenantId").in(tenantIds));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantNameEqual())) {
                predicates.add(builder.equal((Expression)root.get("tenantName"), (Object)query.getTenantNameEqual()));
            } else if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                predicates.add(builder.like((Expression)root.get("tenantName"), query.getTenantName() + "%"));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                }
                criteriaQuery.groupBy(new Expression[]{root.get("tenantId")});
                return criteriaQuery.getGroupRestriction();
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<Tenant> queryOneSpecification(TenantModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            Predicate predicate = null;
            if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicate = builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                predicate = predicate != null ? builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get("tenantCode"), (Object)query.getTenantCode())) : builder.or(new Predicate[]{builder.equal((Expression)root.get("tenantCode"), (Object)query.getTenantCode())});
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                predicate = predicate != null ? builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get("tenantName"), (Object)query.getTenantName())) : builder.or(new Predicate[]{builder.equal((Expression)root.get("tenantName"), (Object)query.getTenantName())});
            }
            if (predicate == null) {
                throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            criteriaQuery.where((Predicate[])Stream.of(predicate).toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

