/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.UserModel;
import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.entity.OrgVirtualNodeUserRel;
import com.xforceplus.entity.RoleUserRel;
import com.xforceplus.entity.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.CollectionUtils;

public class UserQueryHelper {
    private static final Logger logger = LoggerFactory.getLogger(UserQueryHelper.class);

    public static Specification<User> querySpecification(UserModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> UserQueryHelper.toPredicate(query, (Root<User>)root, criteriaQuery, builder);
        return specification;
    }

    public static Predicate queryTuplePredicate(UserModel.Request.Query query, Root<User> root, CriteriaQuery<Tuple> criteriaQuery, CriteriaBuilder builder) {
        return UserQueryHelper.toPredicate(query, root, criteriaQuery, builder);
    }

    public static Predicate queryCountPredicate(UserModel.Request.Query query, Root<User> root, CriteriaQuery<Long> criteriaQuery, CriteriaBuilder builder) {
        return UserQueryHelper.toPredicate(query, root, criteriaQuery, builder);
    }

    private static <T> Predicate toPredicate(UserModel.Request.Query query, Root<User> root, CriteriaQuery<T> criteriaQuery, CriteriaBuilder builder) {
        Predicate[] subPredicates;
        Subquery subquery;
        ArrayList<Predicate> filterPredicates = new ArrayList<Predicate>();
        ArrayList<Predicate> rangePredicates = new ArrayList<Predicate>();
        boolean joinTable = false;
        if (query.getOrgVirtualNodeId() != null && query.getOrgVirtualNodeId() > 0L) {
            if (query.getExcludeBoundOrgVirtualNode() != null && query.getExcludeBoundOrgVirtualNode().booleanValue() && query.getTenantId() != null && query.getTenantId() > 0L) {
                subquery = criteriaQuery.subquery(OrgVirtualNodeUserRel.class);
                Root relOrgVirtualTreeRoot = subquery.from(OrgVirtualNodeUserRel.class);
                subquery.select((Expression)relOrgVirtualTreeRoot);
                subPredicates = new Predicate[]{builder.equal((Expression)relOrgVirtualTreeRoot.get("orgVirtualNodeId"), (Object)query.getOrgVirtualNodeId()), builder.equal((Expression)root.get("id"), (Expression)relOrgVirtualTreeRoot.get("userId"))};
                subquery.where(subPredicates);
                rangePredicates.add(builder.not((Expression)builder.exists(subquery)));
            } else {
                ListJoin userJoinRoleOrgVirtualTreeRel = root.joinList("orgVirtualNodeUserRels", JoinType.LEFT);
                rangePredicates.add(builder.equal((Expression)userJoinRoleOrgVirtualTreeRel.get("orgVirtualNodeId"), (Object)query.getOrgVirtualNodeId()));
            }
        }
        if (query.getExcludeBoundCurrent() != null && query.getTenantId() != null && query.getTenantId() > 0L && query.getExcludeBoundCurrent().booleanValue() && query.getRoleId() != null && query.getRoleId() > 0L) {
            subquery = criteriaQuery.subquery(RoleUserRel.class);
            Root roleUserRel = subquery.from(RoleUserRel.class);
            subquery.select((Expression)roleUserRel);
            subPredicates = new Predicate[]{builder.equal((Expression)roleUserRel.get("roleId"), (Object)query.getRoleId()), builder.equal((Expression)root.get("id"), (Expression)roleUserRel.get("userId"))};
            subquery.where(subPredicates);
            rangePredicates.add(builder.not((Expression)builder.exists(subquery)));
        } else if (query.getRoleId() != null && query.getRoleId() > 0L || StringUtils.isNotBlank((CharSequence)query.getRoleCode()) || StringUtils.isNotBlank((CharSequence)query.getRoleIds())) {
            HashSet<Long> roleIds = new HashSet<Long>();
            if (query.getRoleId() != null && query.getRoleId() > 0L) {
                roleIds.add(query.getRoleId());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getRoleIds())) {
                Arrays.stream(StringUtils.split((String)query.getRoleIds(), (String)",")).forEach(id -> {
                    try {
                        Long parseLong = Long.parseLong(id);
                        roleIds.add(parseLong);
                    }
                    catch (NumberFormatException e) {
                        String message = e.getMessage() + ", id: " + id;
                        logger.warn(message);
                    }
                });
            }
            ListJoin userJoinRoleUserRel = null;
            if (!roleIds.isEmpty()) {
                userJoinRoleUserRel = root.joinList("roleUserRels", JoinType.LEFT);
                if (roleIds.size() == 1) {
                    rangePredicates.add(builder.equal((Expression)userJoinRoleUserRel.get("roleId"), roleIds.stream().findFirst().get()));
                } else {
                    rangePredicates.add(userJoinRoleUserRel.get("roleId").in(roleIds));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)query.getRoleCode())) {
                if (userJoinRoleUserRel == null) {
                    userJoinRoleUserRel = root.joinList("roleUserRels", JoinType.LEFT);
                }
                Join joinRole = userJoinRoleUserRel.join("role", JoinType.LEFT);
                rangePredicates.add(builder.equal((Expression)joinRole.get("code"), (Object)query.getRoleCode()));
                if (query.getStatus() != null && query.getStatus() == 1) {
                    rangePredicates.add(builder.equal((Expression)joinRole.get("status"), (Object)1));
                }
            }
            joinTable = true;
        }
        if (StringUtils.isNotBlank((CharSequence)query.getAccountName()) || StringUtils.isNotBlank((CharSequence)query.getAccountOptions())) {
            Join joinAccount = root.join("account", JoinType.LEFT);
            if (StringUtils.isNotBlank((CharSequence)query.getAccountName())) {
                rangePredicates.add(builder.or(new Predicate[]{builder.equal((Expression)joinAccount.get("username"), (Object)query.getAccountName()), builder.equal((Expression)joinAccount.get("telPhone"), (Object)query.getAccountName()), builder.equal((Expression)joinAccount.get("email"), (Object)query.getAccountName())}));
            } else if (StringUtils.isNotBlank((CharSequence)query.getAccountOptions())) {
                rangePredicates.add(builder.or(new Predicate[]{builder.like((Expression)joinAccount.get("username"), "%" + query.getAccountOptions() + "%"), builder.like((Expression)joinAccount.get("telPhone"), "%" + query.getAccountOptions() + "%"), builder.like((Expression)joinAccount.get("email"), "%" + query.getAccountOptions() + "%")}));
            }
            if (query.getStatus() != null && query.getStatus() == 1) {
                rangePredicates.add(builder.equal((Expression)joinAccount.get("status"), (Object)1));
            }
            joinTable = true;
        }
        if (query.getUserId() != null && query.getUserId() > 0L) {
            filterPredicates.add(builder.equal((Expression)root.get("id"), (Object)query.getUserId()));
        } else if (!CollectionUtils.isEmpty((Collection)query.getUserIds())) {
            if (query.getUserIds().size() == 1) {
                filterPredicates.add(builder.equal((Expression)root.get("id"), query.getUserIds().stream().findFirst().get()));
            } else {
                filterPredicates.add(root.get("id").in((Collection)query.getUserIds()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)query.getUserCode())) {
            filterPredicates.add(builder.equal((Expression)root.get("userCode"), (Object)query.getUserCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getUserName())) {
            filterPredicates.add(builder.equal((Expression)root.get("userName"), (Object)query.getUserName()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getUserNumber())) {
            filterPredicates.add(builder.equal((Expression)root.get("userNumber"), (Object)query.getUserNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getUserPhone())) {
            filterPredicates.add(builder.equal((Expression)root.get("userPhone"), (Object)query.getUserPhone()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getUserEmailAddr())) {
            filterPredicates.add(builder.equal((Expression)root.get("userEmailAddr"), (Object)query.getUserEmailAddr()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getUserOptions())) {
            filterPredicates.add(builder.or(new Predicate[]{builder.like((Expression)root.get("userName"), query.getUserOptions() + "%"), builder.equal((Expression)root.get("userCode"), (Object)query.getUserOptions()), builder.equal((Expression)root.get("userNumber"), (Object)query.getUserOptions()), builder.equal((Expression)root.get("userPhone"), (Object)query.getUserOptions()), builder.equal((Expression)root.get("userEmailAddr"), (Object)query.getUserOptions())}));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getTenantCode()) || StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
            Join joinTenant = root.join("tenant", JoinType.LEFT);
            if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                rangePredicates.add(builder.equal((Expression)joinTenant.get("tenantCode"), (Object)query.getTenantCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                rangePredicates.add(builder.like((Expression)joinTenant.get("tenantName"), query.getTenantName() + "%"));
            }
        }
        if (query.getStatus() != null) {
            filterPredicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
        }
        if (query.getExpired() != null) {
            if (query.getExpired().booleanValue()) {
                filterPredicates.add(builder.lessThan((Expression)root.get("expiredDate"), builder.currentDate()));
            } else {
                filterPredicates.add(builder.greaterThanOrEqualTo((Expression)root.get("expiredDate"), builder.currentDate()));
            }
        }
        if (query.getAfterExpiredDate() != null) {
            filterPredicates.add(builder.lessThan((Expression)root.get("expiredDate"), (Comparable)query.getAfterExpiredDate()));
        }
        if (query.getBeforeExpiredDate() != null) {
            filterPredicates.add(builder.greaterThanOrEqualTo((Expression)root.get("expiredDate"), (Comparable)query.getBeforeExpiredDate()));
        }
        if (query.getAccountId() != null && query.getAccountId() > 0L) {
            filterPredicates.add(builder.equal((Expression)root.get("accountId"), (Object)query.getAccountId()));
        } else if (!CollectionUtils.isEmpty((Collection)query.getAccountIds())) {
            if (query.getAccountIds().size() == 1) {
                filterPredicates.add(builder.equal((Expression)root.get("accountId"), query.getAccountIds().stream().findFirst().get()));
            } else {
                filterPredicates.add(root.get("accountId").in((Collection)query.getAccountIds()));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)query.getFilterOrgParentIds()) || !CollectionUtils.isEmpty((Collection)query.getOrgIds())) {
            ListJoin joinOrgRels = root.joinList("orgUserRels", JoinType.LEFT);
            if (!CollectionUtils.isEmpty((Collection)query.getOrgIds())) {
                if (query.getOrgIds().size() == 1) {
                    rangePredicates.add(builder.equal((Expression)joinOrgRels.get("orgStructId"), query.getOrgIds().stream().findFirst().get()));
                } else {
                    rangePredicates.add(joinOrgRels.get("orgStructId").in((Collection)query.getOrgIds()));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)query.getFilterOrgParentIds())) {
                ArrayList filterParentIdsList = new ArrayList(query.getFilterOrgParentIds());
                Collections.sort(filterParentIdsList);
                HashSet<String> filterParentIdsSet = new HashSet<String>();
                Join joinOrg = joinOrgRels.join("org", JoinType.LEFT);
                for (String filterParentIds : filterParentIdsList) {
                    if (!filterParentIdsSet.stream().noneMatch(parentIds -> StringUtils.startsWith((CharSequence)filterParentIds, (CharSequence)parentIds))) continue;
                    filterParentIdsSet.add(filterParentIds);
                    rangePredicates.add(builder.like((Expression)joinOrg.get("parentIds"), StringUtils.appendIfMissing((String)filterParentIds, (CharSequence)"%", (CharSequence[])new CharSequence[0])));
                }
            }
            joinTable = true;
        }
        Predicate orPredicate = null;
        if (query.getTenantId() != null && query.getTenantId() > 0L) {
            rangePredicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
            if (query.getIncludeIndependents() != null && query.getIncludeIndependents().booleanValue()) {
                Subquery subquery2 = criteriaQuery.subquery(Long.class);
                Root orgUserRel = subquery2.from(OrgUserRel.class);
                subquery2.select((Expression)builder.treat(orgUserRel.get("userId"), Long.class));
                subquery2.groupBy(new Expression[]{orgUserRel.get("userId")});
                Predicate subPredicate = builder.equal((Expression)orgUserRel.get("tenantId"), (Object)query.getTenantId());
                subquery2.where((Expression)subPredicate);
                orPredicate = builder.not((Expression)root.get("id").in(new Expression[]{subquery2}));
            }
        }
        if (!rangePredicates.isEmpty() || !filterPredicates.isEmpty()) {
            if (orPredicate == null) {
                rangePredicates.addAll(filterPredicates);
                criteriaQuery.where((Predicate[])rangePredicates.stream().toArray(Predicate[]::new));
            } else {
                Predicate rangePredicate = builder.and((Predicate[])rangePredicates.stream().toArray(Predicate[]::new));
                Predicate filterPredicate = builder.and((Predicate[])filterPredicates.stream().toArray(Predicate[]::new));
                criteriaQuery.where((Expression)builder.and((Expression)builder.or((Expression)rangePredicate, orPredicate), (Expression)filterPredicate));
            }
        } else if (orPredicate != null) {
            criteriaQuery.where(orPredicate);
        }
        if (joinTable) {
            if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                criteriaQuery.distinct(true);
                return criteriaQuery.getRestriction();
            }
            criteriaQuery.groupBy(new Expression[]{root.get("id")});
            return criteriaQuery.getGroupRestriction();
        }
        return criteriaQuery.getRestriction();
    }

    public static Specification<User> queryOneSpecification(UserModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getUserId() != null && query.getUserId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("id"), (Object)query.getUserId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getUserCode())) {
                predicates.add(builder.equal((Expression)root.get("userCode"), (Object)query.getUserCode()));
            }
            if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

