/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: OrgUserDTO.java   2020-12-28 16-23-18
 * Author: Evan
 */
package com.xforceplus.dto.user;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Date;

/**
 * <p>
 * Title: OrgUserDTO
 * </p>
 * <p>
 * Description:OrgUserDTO
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-12-28 16-23-18
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class OrgUserDTO {

    /**
     * 租户Id
     */
    private Long tenantId;
    /**
     * 组织ID
     */
    private Long orgId;
    /**
     * 组织ID
     */
    private String orgCode;
    /**
     * 当组织是公司类型的时，则该字段不为空
     */
    private Long companyId;
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 用户状态：
     */
    private Integer userStatus;
    /**
     * 用户类型：
     */
    private Integer userType;
    /**
     * 用户-姓名
     */
    private String realName;
    /**
     * 用户代码
     */
    private String userCode;
    /**
     * 用户-员工号
     */
    private String userNumber;
    /**
     * 用户-手机号
     */
    private String userTelPhone;
    /**
     * 用户创建时间
     */
    private Date createdTime;
    /**
     * 账号ID
     */
    @ApiModelProperty("账号ID")
    private Long accountId;
    /**
     * 账号-用户名
     */
    private String accountUserName;
    /**
     * 账号-Email
     */
    private String accountEmail;
    /**
     * 账号-手机号
     */
    private String accountTelPhone;

    /**
     * 用户-组织绑定时间
     */
    private Date boundTime;
}
