package com.xforceplus.entity;

import com.xforceplus.domain.client.ClientResourcesetRelDto;
import com.xforceplus.domain.client.ClientTenantRelDto;
import io.geewit.data.jpa.essential.id.IDGenerators;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

/**
 * @author zhouxin
 */
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_client_resourceset_rel")
public class ClientResourcesetRel extends ClientResourcesetRelDto implements Serializable {

    @Override
    @Id
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    @Override
    @Column(name = "client_id")
    public String getClientId() {
        return clientId;
    }

    @Override
    @Column(name = "create_user_id")
    public String getCreateUserId() {
        return createUserId;
    }

    @Override
    @Column(name = "create_user_name")
    public String getCreateUserName() {
        return createUserName;
    }

    @Override
    @Column(name = "resourceset_id")
    public Long getResourcesetId() {
        return resourcesetId;
    }

    @Override
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public String toString() {
        return "ClientResourcesetRel{" +
            "id=" + id +
            ", clientId='" + clientId + '\'' +
            ", resourcesetId=" + resourcesetId +
            ", createUserId='" + createUserId + '\'' +
            ", createUserName='" + createUserName + '\'' +
            ", createTime=" + createTime +
            '}';
    }
}
