package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.jpa.listener.CompanyTenantRelAuditListener;
import com.xforceplus.tenant.security.core.domain.ICreater;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.swagger.annotations.ApiModelProperty;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.util.Date;

/**
 * 公司租户关联关系 Audit Entity
 *
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@Setter
@EntityListeners({CompanyTenantRelAuditListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "company_tenant_rel_audit")
public class CompanyTenantRelAudit implements ICreater {
    private Long id;
    /**
     * 公司租户关联关系id
     */
    private Long relId;
    /**
     * 开关组合
     */
    private Integer switches;
    /**
     * 开关组合增加部分
     */
    private Integer switchAdditions;
    /**
     * 共享历史发票授权时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date invoiceGrantedTime;
    /**
     * 共享历史发票起始日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date invoiceStartDate;
    /**
     * 共享历史结算单授权时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date statementGrantedTime;
    /**
     * 共享历史结算单起始日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date statementStartDate;
    @ApiModelProperty(value = "创建人id")
    private String createrId;

    @ApiModelProperty(value = "创建人名称")
    private String createrName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty(value = "备注")
    private String remark;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "rel_id")
    public Long getRelId() {
        return relId;
    }

    @Basic
    @Column(name = "switches", updatable = false)
    public Integer getSwitches() {
        return switches;
    }

    /**
     * 开关组合增加部分
     * @return 开关组合增加部分
     */
    @Basic
    @Column(name = "switch_additions", nullable = false)
    public Integer getSwitchAdditions() {
        return switchAdditions;
    }

    @Temporal(TemporalType.DATE)
    @Column(name = "statement_start_date", updatable = false)
    public Date getStatementStartDate() {
        return statementStartDate;
    }

    @Transient
    public Date getStatementGrantedTime() {
        return statementGrantedTime;
    }

    @Temporal(TemporalType.DATE)
    @Column(name = "invoice_start_date", updatable = false)
    public Date getInvoiceStartDate() {
        return invoiceStartDate;
    }

    @Transient
    public Date getInvoiceGrantedTime() {
        return invoiceGrantedTime;
    }

    @Override
    @Basic
    @Column(name = "creater_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "creater_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Column(name = "remark", updatable = false)
    public String getRemark() {
        return remark;
    }
}
