package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.*;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.jpa.listener.OrgListener;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.tenant.security.core.domain.view.OrgView;
import io.geewit.core.jackson.view.View;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;


/**
 * 组织机构
 *
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@NamedEntityGraphs({
        @NamedEntityGraph(name = OrgStruct.NAMED_ENTITY_GRAPH_DEFAULT,
                attributeNodes = {
                        @NamedAttributeNode("company"),
                        @NamedAttributeNode("tenant"),
                        @NamedAttributeNode("gradingRole"),
                        @NamedAttributeNode("defaultOrgRole")
                }
        )
})
@EntityListeners({OrgListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_org_struct")
public class OrgStruct extends OrgDto<OrgStruct> implements Serializable {
    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "Org.graph";

    /**
     * 是否已经执行过 buildParentIds()
     */
    @JsonIgnore
    public boolean builtParentIds;
    @JsonView(OrgView.OrgInfo.class)
    @JsonManagedReference
    private Company company;
    @JsonView(OrgView.OrgInfo.class)
    @JsonManagedReference
    private Tenant tenant;
    @JsonView(OrgView.OrgInfo.class)
    private List<ServicePackage> packages;
    @JsonIgnore
    private List<OrgUserRel> orgUserRels;
    @JsonView(OrgView.OrgInfo.class)
    @JsonManagedReference
    private Role gradingRole;
    @JsonView(OrgView.OrgInfo.class)
    @JsonManagedReference
    private Role defaultOrgRole;

    @Override
    @Id
    @Column(name = "org_struct_id", nullable = false)
    @Basic
    public Long getOrgId() {
        return super.id;
    }

    @Override
    public void setOrgId(Long orgId) {
        super.id = orgId;
    }

    @Override
    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return this.tenantId;
    }

    @Override
    @Basic
    @Column(name = "company_id")
    public Long getCompanyId() {
        return this.companyId;
    }

    @Override
    @Basic
    @Column(name = "grading_role_id")
    public Long getGradingRoleId() {
        return this.gradingRoleId;
    }

    @Override
    @Basic
    @Column(name = "default_org_role_id")
    public Long getDefaultOrgRoleId() {
        return this.defaultOrgRoleId;
    }


    @Override
    @Basic
    @Column(name = "org_code", nullable = false)
    public String getOrgCode() {
        return orgCode;
    }


    @Override
    @Basic
    @Column(name = "org_name", nullable = false)
    public String getOrgName() {
        return orgName;
    }

    @Override
    @Basic
    @Column(name = "parent_ids", nullable = false)
    public String getParentIds() {
        return parentIds;
    }

    @Override
    @Basic
    @Column(name = "parent_id")
    public Long getParentId() {
        return (parentId != null && parentId > 0) ? parentId : null;
    }

    @Override
    @Enumerated(EnumType.ORDINAL)
    @Column(name = "org_type", nullable = false)
    @Basic
    public OrgType getOrgType() {
        return orgType;
    }

    @Override
    @Basic
    @Column(name = "org_biz_type")
    public String getOrgBizType() {
        return orgBizType;
    }

    @Override
    @Basic
    @Column(name = "org_desc", nullable = false)
    public String getOrgDesc() {
        return orgDesc;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "audit_status")
    public Integer getAuditStatus() {
        return auditStatus;
    }

    @Override
    @Basic
    @Column(name = "enabled_time")
    public Date getEnabledTime() {
        return enabledTime;
    }

    @Override
    @Basic
    @Column(name = "disabled_time")
    public Date getDisabledTime() {
        return disabledTime;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }


    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    @Basic
    public Date getUpdateTime() {
        return updateTime;
    }

    @JsonView({View.List.class, OrgView.OrgInfo.class})
    @Override
    @ElementCollection(fetch = FetchType.LAZY)
    @CollectionTable(name = "sys_org_companyno", joinColumns = @JoinColumn(name = "org_struct_id"))
    @Column(name = "company_no", insertable = false, updatable = false)
    public Set<String> getCompanyNos() {
        return super.companyNos;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "tenant_id", referencedColumnName = "tenant_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return tenant;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "company_id", referencedColumnName = "company_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @NotFound(action = NotFoundAction.IGNORE)
    public Company getCompany() {
        return company;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "grading_role_id", referencedColumnName = "role_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Role getGradingRole() {
        return gradingRole;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "default_org_role_id", referencedColumnName = "role_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Role getDefaultOrgRole() {
        return defaultOrgRole;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getParentName() {
        return super.parentName;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getGradingRoleName() {
        if (super.gradingRoleName == null && this.gradingRole != null) {
            if (this.gradingRole.isValid()) {
                super.gradingRoleName = this.gradingRole.getName();
            }
        }
        return super.gradingRoleName;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getDefaultOrgRoleName() {
        if (super.defaultOrgRoleName == null && this.defaultOrgRole != null) {
            if (this.defaultOrgRole.isValid()) {
                super.defaultOrgRoleName = this.defaultOrgRole.getName();
            }
        }
        return super.defaultOrgRoleName;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getGradingRoleCode() {
        if (super.gradingRoleCode == null && this.gradingRole != null) {
            if (this.gradingRole.isValid()) {
                super.gradingRoleCode = this.gradingRole.getCode();
            }
        }
        return super.gradingRoleCode;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getDefaultOrgRoleCode() {
        if (super.defaultOrgRoleCode == null && this.defaultOrgRole != null) {
            if (this.defaultOrgRole.isValid()) {
                super.defaultOrgRoleCode = this.defaultOrgRole.getCode();
            }
        }
        return super.defaultOrgRoleCode;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getCompanyName() {
        if (super.companyName != null) {
            return super.companyName;
        }
        try {
            if (this.company != null) {
                super.companyName = this.company.getCompanyName();
            }
        } catch (Exception ignore) {
        }
        return super.companyName;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getCompanyCode() {
        if (super.companyCode != null) {
            return super.companyCode;
        }
        try {
            if (this.company != null) {
                super.companyCode = this.company.getCompanyCode();
            }
        } catch (Exception ignore) {
        }
        return super.companyCode;
    }

    @JsonIgnore
    @Transient
    public boolean isCompanyLoaded() {
        return super.companyId != null && super.companyId > 0 && super.companyName != null;
    }

    @JsonView(View.List.class)
    @Transient
    @Override
    public String getTaxNum() {
        if (super.taxNum != null) {
            return super.taxNum;
        }
        try {
            if (this.company != null) {
                super.taxNum = this.company.getTaxNum();
            }
        } catch (Exception ignore) {
        }
        return super.taxNum;
    }

    @Override
    @JsonView(View.List.class)
    @Transient
    public String getTenantName() {
        if (super.tenantName != null) {
            return super.tenantName;
        }
        try {
            if (this.tenant != null) {
                super.tenantName = this.tenant.getTenantName();
            }
        } catch (Exception ignore) {
        }
        return super.tenantName;
    }

    @JsonIgnore
    @Transient
    public boolean isTenantLoaded() {
        return super.tenantId != null && super.tenantId > 0 && super.tenantName != null;
    }

    @Override
    @JsonView(View.List.class)
    @Transient
    public String getTenantCode() {
        if (super.tenantCode != null) {
            return super.tenantCode;
        }
        try {
            if (this.tenant != null) {
                super.tenantCode = this.tenant.getTenantCode();
            }
        } catch (Exception ignore) {
        }
        return super.tenantCode;
    }

    public void setCompany(Company company) {
        this.company = company;
        if (company != null) {
            super.companyName = company.getCompanyName();
            super.companyCode = company.getCompanyCode();
            super.taxNum = company.getTaxNum();
        }
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
        if (tenant != null) {
            super.tenantName = tenant.getTenantName();
            super.tenantCode = tenant.getTenantCode();
        }
    }

    public void setGradingRole(Role gradingRole) {
        this.gradingRole = gradingRole;
        if (gradingRole != null) {
            super.gradingRoleName = gradingRole.getName();
            super.gradingRoleCode = gradingRole.getCode();
        }
    }

    public void setDefaultOrgRole(Role defaultOrgRole) {
        this.defaultOrgRole = defaultOrgRole;
        if (defaultOrgRole != null) {
            super.defaultOrgRoleName = defaultOrgRole.getName();
            super.defaultOrgRoleCode = defaultOrgRole.getCode();
        }
    }

    @JsonView(OrgView.Info.class)
    @Transient
    public List<ServicePackage> getPackages() {
        return packages;
    }

    @JsonIgnore
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "org")
    public List<OrgUserRel> getOrgUserRels() {
        return orgUserRels;
    }

    @Override
    @JsonView(View.class)
    @Transient
    public List<OrgStruct> getParentOrgs() {
        return super.parentOrgs;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
